/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.validation.validator;

import ch.usi.si.seart.validation.constraints.Password;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class PasswordValidator
implements ConstraintValidator<Password, CharSequence> {
    private static final String TEMPLATE = "^%s.%s$";
    private int min;
    private int max;
    private Pattern pattern;

    public void initialize(Password constraintAnnotation) {
        this.min = constraintAnnotation.minLength();
        this.max = constraintAnnotation.maxLength();
        this.validateParameters();
        String expressions = Stream.of(constraintAnnotation.requirements()).map(Password.Requirement::getRegexp).collect(Collectors.joining());
        String size = this.max < Integer.MAX_VALUE ? "{" + this.min + "," + this.max + "}" : "{" + this.min + ",}";
        String regex = String.format(TEMPLATE, expressions, size);
        this.pattern = Pattern.compile(regex);
    }

    private void validateParameters() {
        if (this.min < 1) {
            throw new IllegalArgumentException("The min parameter cannot be negative or zero.");
        }
        if (this.max < 1) {
            throw new IllegalArgumentException("The max parameter cannot be negative or zero.");
        }
        if (this.max < this.min) {
            throw new IllegalArgumentException("The length cannot be negative.");
        }
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        return value != null && this.pattern.matcher(value).matches();
    }
}

