/*
 * DO NOT EDIT THIS FILE MANUALLY! IT IS MACHINE GENERATED!
 *
 * MIT License
 *
 * Copyright (c) 2023-present SEART Research Group and Contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package ch.usi.si.seart.validation.validator;

import ch.usi.si.seart.validation.constraints.Password;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PasswordValidator implements ConstraintValidator<Password, CharSequence> {

    private static final String TEMPLATE = "^%s.%s$";

    private int min;
    private int max;

    private Pattern pattern;

    @Override
    public void initialize(Password constraintAnnotation) {
        min = constraintAnnotation.minLength();
        max = constraintAnnotation.maxLength();
        validateParameters();
        String expressions = Stream.of(constraintAnnotation.requirements())
                .map(Password.Requirement::getRegexp)
                .collect(Collectors.joining());
        String size = (max < Integer.MAX_VALUE)
                ? "{" + min + "," + max + "}"
                : "{" + min + ",}";
        String regex = String.format(TEMPLATE, expressions, size);
        pattern = Pattern.compile(regex);
    }

    private void validateParameters() {
        if (min < 1) throw new IllegalArgumentException("The min parameter cannot be negative or zero.");
        if (max < 1) throw new IllegalArgumentException("The max parameter cannot be negative or zero.");
        if (max < min) throw new IllegalArgumentException("The length cannot be negative.");
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        return value != null && pattern.matcher(value).matches();
    }
}
