/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.Node;
import ch.usi.si.seart.treesitter.Point;
import ch.usi.si.seart.treesitter.TreeCursor;
import ch.usi.si.seart.treesitter.TreeCursorNode;
import java.util.Collections;
import lombok.Generated;

public class SyntaxTreePrinter {
    private int depth = 0;
    private final Node node;
    private Point offset = new Point(0, 0);

    public SyntaxTreePrinter(Node node, Point offset) {
        this.node = node;
        this.offset = offset;
    }

    public String printSubtree() {
        StringBuilder stringBuilder = new StringBuilder();
        TreePrinterCursor cursor = new TreePrinterCursor(this.node);
        try {
            while (true) {
                TreeCursorNode cursorNode;
                if ((cursorNode = cursor.getCurrentTreeCursorNode()).isNamed()) {
                    this.recalculatePosition(cursorNode);
                    String indentation = "  ".repeat(this.depth);
                    stringBuilder.append(indentation).append(cursorNode).append("\n");
                }
                if (((TreeCursor)cursor).gotoFirstChild() || cursor.gotoNextSibling()) continue;
                do {
                    if (((TreeCursor)cursor).gotoParent()) continue;
                    String string = stringBuilder.toString();
                    return string;
                } while (!cursor.gotoNextSibling());
            }
        }
        finally {
            if (Collections.singletonList(cursor).get(0) != null) {
                cursor.close();
            }
        }
    }

    private void recalculatePosition(TreeCursorNode cursorNode) {
        if (!this.offset.isOrigin()) {
            Point cursorStartPoint = cursorNode.getStartPoint();
            Point cursorEndPoint = cursorNode.getEndPoint();
            int rowOffset = this.offset.getRow();
            cursorStartPoint.setRow(cursorStartPoint.getRow() + rowOffset);
            cursorEndPoint.setRow(cursorEndPoint.getRow() + rowOffset);
            int columnOffset = this.offset.getColumn();
            cursorStartPoint.setColumn(cursorStartPoint.getColumn() + columnOffset);
            cursorEndPoint.setColumn(cursorEndPoint.getColumn() + columnOffset);
        }
    }

    @Generated
    public SyntaxTreePrinter(Node node) {
        this.node = node;
    }

    private final class TreePrinterCursor
    extends TreeCursor {
        private TreePrinterCursor(Node node) {
            super(node);
        }

        @Override
        public boolean gotoFirstChild() {
            boolean success = super.gotoFirstChild();
            if (success) {
                ++SyntaxTreePrinter.this.depth;
            }
            return success;
        }

        @Override
        public boolean gotoParent() {
            boolean success = super.gotoParent();
            if (success) {
                --SyntaxTreePrinter.this.depth;
            }
            return success;
        }
    }
}

