/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import java.util.Objects;
import lombok.Generated;

public enum Language {
    _INVALID_,
    AGDA(Language.agda()),
    BASH(Language.bash()),
    C(Language.c()),
    CSHARP(Language.cSharp()),
    CPP(Language.cpp()),
    CSS(Language.css()),
    DART(Language.dart()),
    ELM(Language.elm()),
    EMBEDDED_TEMPLATE(Language.embeddedTemplate()),
    ENO(Language.eno()),
    GO(Language.go()),
    HASKELL(Language.haskell()),
    HTML(Language.html()),
    JAVA(Language.java()),
    JAVASCRIPT(Language.javascript()),
    JULIA(Language.julia()),
    KOTLIN(Language.kotlin()),
    LUA(Language.lua()),
    MARKDOWN(Language.markdown()),
    OCAML(Language.ocaml()),
    PHP(Language.php()),
    PYTHON(Language.python()),
    RUBY(Language.ruby()),
    RUST(Language.rust()),
    SCALA(Language.scala()),
    SCSS(Language.scss()),
    SWIFT(Language.swift()),
    TOML(Language.toml()),
    TSX(Language.tsx()),
    TYPESCRIPT(Language.typescript()),
    VUE(Language.vue()),
    YAML(Language.yaml()),
    WASM(Language.wasm());

    private final long id;
    private static final long INVALID = 0L;

    static native long agda();

    static native long bash();

    static native long c();

    static native long cSharp();

    static native long cpp();

    static native long css();

    static native long dart();

    static native long elm();

    static native long embeddedTemplate();

    static native long eno();

    static native long go();

    static native long haskell();

    static native long html();

    static native long java();

    static native long javascript();

    static native long julia();

    static native long kotlin();

    static native long lua();

    static native long markdown();

    static native long ocaml();

    static native long php();

    static native long python();

    static native long ruby();

    static native long rust();

    static native long scala();

    static native long scss();

    static native long swift();

    static native long toml();

    static native long tsx();

    static native long typescript();

    static native long vue();

    static native long yaml();

    static native long wasm();

    public static void validate(Language language) {
        Objects.requireNonNull(language, "Language must not be null!");
        long id = language.getId();
        if (id == 0L) {
            throw new UnsatisfiedLinkError("Language binding has not been defined for: " + language);
        }
    }

    private Language() {
        this(0L);
    }

    private Language(long id) {
        this.id = id;
    }

    public String toString() {
        switch (this) {
            case C: 
            case CSS: 
            case HTML: 
            case PHP: 
            case SCSS: 
            case TOML: 
            case TSX: 
            case YAML: {
                return this.name();
            }
            case AGDA: 
            case BASH: 
            case DART: 
            case ELM: 
            case ENO: 
            case GO: 
            case HASKELL: 
            case JAVA: 
            case JULIA: 
            case KOTLIN: 
            case LUA: 
            case MARKDOWN: 
            case PYTHON: 
            case RUBY: 
            case RUST: 
            case SCALA: 
            case SWIFT: 
            case VUE: {
                return this.name().charAt(0) + this.name().substring(1).toLowerCase();
            }
            case CSHARP: {
                return "C#";
            }
            case CPP: {
                return "C++";
            }
            case EMBEDDED_TEMPLATE: {
                return "Embedded Template";
            }
            case JAVASCRIPT: {
                return "JavaScript";
            }
            case OCAML: {
                return "OCaml";
            }
            case TYPESCRIPT: {
                return "TypeScript";
            }
            case WASM: {
                return "WebAssembly";
            }
        }
        return "???";
    }

    @Generated
    public long getId() {
        return this.id;
    }
}

