/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.External;
import ch.usi.si.seart.treesitter.Language;
import ch.usi.si.seart.treesitter.Tree;
import ch.usi.si.seart.treesitter.exception.parser.IncompatibleLanguageException;
import ch.usi.si.seart.treesitter.exception.parser.ParsingException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Parser
extends External {
    private final Language language;
    private static final Charset CHARSET = StandardCharsets.UTF_16LE;
    private static final String NULL_LANGUAGE = "Language must not be null!";
    private static final String NULL_DURATION = "Duration must not be null!";
    private static final String NULL_TIME_UNIT = "Time unit must not be null!";
    private static final String NEGATIVE_TIMEOUT = "Timeout must not be negative!";

    Parser(long pointer, @NotNull Language language) {
        super(pointer);
        this.language = language;
    }

    public static Parser getFor(@NotNull Language language) {
        return Parser.builder().language(language).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Parser.builder().language(this.getLanguage()).timeout(this.getTimeout());
    }

    public static native int getLanguageVersion();

    public static native int getMinimumCompatibleLanguageVersion();

    @Override
    protected native void delete();

    public void setLanguage(@NotNull Language language) {
        Language.validate(language);
        Parser.setLanguage(this, language);
    }

    private static native void setLanguage(Parser var0, Language var1) throws IncompatibleLanguageException;

    public native long getTimeout();

    public void setTimeout(@NotNull Duration duration) {
        Objects.requireNonNull(duration, NULL_DURATION);
        long micros = duration.toMillis() * TimeUnit.MILLISECONDS.toMicros(1L);
        this.setTimeout(micros);
    }

    public void setTimeout(long timeout, @NotNull TimeUnit timeUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException(NEGATIVE_TIMEOUT);
        }
        Objects.requireNonNull(timeUnit, NULL_TIME_UNIT);
        long micros = timeUnit.toMicros(timeout);
        this.setTimeout(micros);
    }

    public native void setTimeout(long var1);

    public Tree parse(@NotNull String source) throws ParsingException {
        byte[] bytes = source.getBytes(CHARSET);
        return this.parse(source, bytes, bytes.length, null);
    }

    public Tree parse(@NotNull String source, @NotNull Tree oldTree) throws ParsingException {
        byte[] bytes = source.getBytes(CHARSET);
        return this.parse(source, bytes, bytes.length, oldTree);
    }

    public Tree parse(@NotNull Path path) throws ParsingException {
        try {
            String source = Files.readString(path);
            return this.parse(source);
        }
        catch (IOException ex) {
            throw new ParsingException(ex);
        }
    }

    public Tree parse(@NotNull Path path, @NotNull Tree oldTree) throws ParsingException {
        try {
            String source = Files.readString(path);
            return this.parse(source, oldTree);
        }
        catch (IOException ex) {
            throw new ParsingException(ex);
        }
    }

    private native Tree parse(String var1, byte[] var2, int var3, Tree var4);

    @Generated
    public Language getLanguage() {
        return this.language;
    }

    public static class Builder {
        private Language language = null;
        private long timeout = 0L;

        public Builder language(@NotNull Language language) {
            Language.validate(language);
            this.language = language;
            return this;
        }

        public Builder timeout(@NotNull Duration duration) {
            Objects.requireNonNull(duration, Parser.NULL_DURATION);
            if (duration.isZero()) {
                return this;
            }
            long micros = duration.toMillis() * TimeUnit.MILLISECONDS.toMicros(1L);
            return this.timeout(micros);
        }

        public Builder timeout(long timeout, @NotNull TimeUnit timeUnit) {
            if (timeout == 0L) {
                return this;
            }
            if (timeout < 0L) {
                throw new IllegalArgumentException(Parser.NEGATIVE_TIMEOUT);
            }
            Objects.requireNonNull(timeUnit, Parser.NULL_TIME_UNIT);
            long micros = timeUnit.toMicros(timeout);
            return this.timeout(micros);
        }

        public Builder timeout(long timeout) {
            if (timeout == 0L) {
                return this;
            }
            if (timeout < 0L) {
                throw new IllegalArgumentException(Parser.NEGATIVE_TIMEOUT);
            }
            this.timeout = timeout;
            return this;
        }

        public Parser build() {
            Objects.requireNonNull(this.language, Parser.NULL_LANGUAGE);
            return Builder.build(this.language, this.timeout);
        }

        private static native Parser build(Language var0, long var1);

        @Generated
        private Builder() {
        }
    }
}

