/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter.printer;

import ch.usi.si.seart.treesitter.TreeCursor;
import ch.usi.si.seart.treesitter.function.IOExceptionThrowingConsumer;
import ch.usi.si.seart.treesitter.printer.TreePrinter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

abstract class IterativeTreePrinter
implements TreePrinter {
    protected final TreeCursor cursor;

    protected IterativeTreePrinter(@NotNull TreeCursor cursor) {
        this.cursor = Objects.requireNonNull(cursor, "Cursor must not be null!");
    }

    @Override
    public final String print() {
        StringBuilder stringBuilder = new StringBuilder(this.getPreamble());
        this.write(stringBuilder::append);
        return stringBuilder.toString();
    }

    @Override
    public final File export() throws IOException {
        File file;
        File file2 = Files.createTempFile("ts-export-", this.getFileExtension(), new FileAttribute[0]).toFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file2));
        try {
            writer.append(this.getPreamble());
            Consumer<String> appender = IOExceptionThrowingConsumer.toUnchecked(writer::append);
            this.write(appender);
            file = file2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        }
        ((Writer)writer).close();
        return file;
    }

    protected String getPreamble() {
        return "";
    }

    protected String getFileExtension() {
        return "";
    }

    protected abstract void write(Consumer<String> var1);
}

