/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.Parser;
import ch.usi.si.seart.treesitter.Symbol;
import ch.usi.si.seart.treesitter.error.ABIVersionError;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

public enum Language {
    _INVALID_,
    ADA(Language.ada(), "adb", "ads"),
    BASH(Language.bash(), "sh", "bash"),
    C(Language.c(), "c", "h"),
    CLOJURE(Language.clojure(), "bb", "clj", "cljc", "cljs"),
    CMAKE(Language.cmake(), "cmake"),
    COMMON_LISP(Language.commonLisp(), "lisp"),
    C_SHARP(Language.cSharp(), "cs"),
    CPP(Language.cpp(), "cc", "cpp", "cxx", "hpp", "hxx", "h"),
    CSS(Language.css(), "css"),
    DART(Language.dart(), "dart"),
    DOT(Language.dot(), "dot", "gv"),
    DTD(Language.dtd(), "dtd"),
    ELIXIR(Language.elixir(), "ex", "exs"),
    ELM(Language.elm(), "elm"),
    EMBEDDED_TEMPLATE(Language.embeddedTemplate(), "ejs", "erb"),
    ERLANG(Language.erlang(), "erl", "hrl"),
    FORTRAN(Language.fortran(), "f", "F90", "f77", "f90", "f95"),
    GITATTRIBUTES(Language.gitattributes(), "gitattributes"),
    GITIGNORE(Language.gitignore(), "gitignore"),
    GO(Language.go(), "go"),
    GRAPHQL(Language.graphql(), "graphql"),
    HCL(Language.hcl(), "hcl", "tf", "tfvars"),
    HASKELL(Language.haskell(), "hs"),
    HTML(Language.html(), "html"),
    JAVA(Language.java(), "java"),
    JAVASCRIPT(Language.javascript(), "js"),
    JSON(Language.json(), "json"),
    JULIA(Language.julia(), "jl"),
    KOTLIN(Language.kotlin(), "kt", "kts"),
    LATEX(Language.latex(), "tex", "sty", "cls", "aux"),
    LUA(Language.lua(), "lua"),
    MARKDOWN(Language.markdown(), "md"),
    NIX(Language.nix(), "nix"),
    OBJECTIVE_C(Language.objectiveC(), "h", "m"),
    OCAML(Language.ocaml(), "ml", "mli"),
    PASCAL(Language.pascal(), "pas", "pp", "lpr"),
    PHP(Language.php(), "php"),
    PYTHON(Language.python(), "py"),
    R(Language.r(), "R", "r"),
    RACKET(Language.racket(), "rkt"),
    RUBY(Language.ruby(), "rb"),
    RUST(Language.rust(), "rs"),
    SCALA(Language.scala(), "scala", "sbt"),
    SCHEME(Language.scheme(), "scm", "ss"),
    SCSS(Language.scss(), "scss"),
    SVELTE(Language.svelte(), "svelte"),
    SWIFT(Language.swift(), "swift"),
    THRIFT(Language.thrift(), "thrift"),
    TOML(Language.toml(), "toml"),
    TSX(Language.tsx(), "tsx"),
    TWIG(Language.twig(), "twig"),
    TYPESCRIPT(Language.typescript(), "ts"),
    VERILOG(Language.verilog(), "v", "vh", "vlg", "verilog"),
    XML(Language.xml(), "svg", "xml", "xsd", "xslt"),
    YAML(Language.yaml(), "yaml", "yml"),
    ZIG(Language.zig(), "zig");

    private final long id;
    private final int version;
    private final int totalFields;
    private final Collection<Symbol> symbols;
    private final List<String> extensions;
    private static final long INVALID = 0L;
    private static final Properties PROPERTIES;
    private static final Map<String, List<Language>> EXTENSION_LOOKUP;

    private static native long ada();

    private static native long bash();

    private static native long c();

    private static native long clojure();

    private static native long commonLisp();

    private static native long cmake();

    private static native long cSharp();

    private static native long cpp();

    private static native long css();

    private static native long dart();

    private static native long dot();

    private static native long dtd();

    private static native long elixir();

    private static native long elm();

    private static native long embeddedTemplate();

    private static native long erlang();

    private static native long fortran();

    private static native long gitattributes();

    private static native long gitignore();

    private static native long go();

    private static native long graphql();

    private static native long haskell();

    private static native long hcl();

    private static native long html();

    private static native long java();

    private static native long javascript();

    private static native long json();

    private static native long julia();

    private static native long kotlin();

    private static native long latex();

    private static native long lua();

    private static native long markdown();

    private static native long nix();

    private static native long objectiveC();

    private static native long ocaml();

    private static native long pascal();

    private static native long php();

    private static native long python();

    private static native long ruby();

    private static native long r();

    private static native long racket();

    private static native long rust();

    private static native long scala();

    private static native long scheme();

    private static native long scss();

    private static native long svelte();

    private static native long swift();

    private static native long thrift();

    private static native long toml();

    private static native long tsx();

    private static native long twig();

    private static native long typescript();

    private static native long verilog();

    private static native long xml();

    private static native long yaml();

    private static native long zig();

    public static void validate(@NotNull Language language) {
        Objects.requireNonNull(language, "Language must not be null!");
        long id = language.getId();
        if (id == 0L) {
            throw new UnsatisfiedLinkError("Language binding has not been defined for: " + language);
        }
        int version = language.getVersion();
        int minimum = Parser.getMinimumCompatibleLanguageVersion();
        int maximum = Parser.getLanguageVersion();
        if (version < minimum || version > maximum) {
            throw new ABIVersionError(version);
        }
    }

    @NotNull
    public static Collection<Language> associatedWith(@NotNull Path path) {
        Objects.requireNonNull(path, "Path argument must not be null!");
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path argument must not be a directory!");
        }
        String name = path.getFileName().toString();
        String extension = FilenameUtils.getExtension((String)name);
        return Optional.of(extension).map(EXTENSION_LOOKUP::get).orElseGet(Collections::emptyList);
    }

    private static native int version(long var0);

    private static native int symbols(long var0);

    private static native Symbol symbol(long var0, int var2);

    private static native int fields(long var0);

    private Language() {
        this(0L);
    }

    private Language(long id) {
        this(id, 0, 0, 0, Collections.emptyList());
    }

    private Language(long id, String ... extensions) {
        this(id, Language.version(id), Language.fields(id), Language.symbols(id), List.of(extensions));
    }

    private Language(long id, int version, int totalFields, int totalSymbols, List<String> extensions) {
        this.id = id;
        this.version = version;
        this.totalFields = totalFields;
        this.symbols = IntStream.range(0, totalSymbols).mapToObj(symbolId -> Language.symbol(id, symbolId)).collect(Collectors.toUnmodifiableList());
        this.extensions = extensions;
    }

    @Generated
    public int getTotalSymbols() {
        return this.symbols.size();
    }

    public String toString() {
        switch (this) {
            case C: 
            case CSS: 
            case DOT: 
            case DTD: 
            case HCL: 
            case HTML: 
            case JSON: 
            case PHP: 
            case R: 
            case SCSS: 
            case TOML: 
            case TSX: 
            case XML: 
            case YAML: {
                return this.name();
            }
            case GITATTRIBUTES: 
            case GITIGNORE: {
                return this.name().toLowerCase();
            }
            case ADA: 
            case BASH: 
            case CLOJURE: 
            case DART: 
            case ELIXIR: 
            case ELM: 
            case ERLANG: 
            case FORTRAN: 
            case GO: 
            case HASKELL: 
            case JAVA: 
            case JULIA: 
            case KOTLIN: 
            case LUA: 
            case MARKDOWN: 
            case NIX: 
            case PASCAL: 
            case PYTHON: 
            case RACKET: 
            case RUBY: 
            case RUST: 
            case SCALA: 
            case SCHEME: 
            case SVELTE: 
            case SWIFT: 
            case THRIFT: 
            case TWIG: 
            case VERILOG: 
            case ZIG: {
                return Language.capitalize(this.name());
            }
            case COMMON_LISP: 
            case EMBEDDED_TEMPLATE: {
                String[] parts = this.name().split("_");
                return Stream.of(parts).map(Language::capitalize).collect(Collectors.joining(" "));
            }
            case C_SHARP: {
                return "C#";
            }
            case CMAKE: {
                return "CMake";
            }
            case CPP: {
                return "C++";
            }
            case GRAPHQL: {
                return "GraphQL";
            }
            case JAVASCRIPT: {
                return "JavaScript";
            }
            case LATEX: {
                return "LaTeX";
            }
            case OBJECTIVE_C: {
                return "Objective-C";
            }
            case OCAML: {
                return "OCaml";
            }
            case TYPESCRIPT: {
                return "TypeScript";
            }
        }
        return "???";
    }

    private static String capitalize(String name) {
        return name.charAt(0) + name.substring(1).toLowerCase();
    }

    public Metadata getMetadata() {
        return new Metadata(this.getURL(), this.getSHA(), this.getTag());
    }

    private URL getURL() {
        String key = "url." + this.getSubmoduleName();
        String value = PROPERTIES.getProperty(key);
        if (value == null) {
            return null;
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private String getSHA() {
        String key = "sha." + this.getSubmoduleName();
        return PROPERTIES.getProperty(key);
    }

    private String getTag() {
        String key = "tag." + this.getSubmoduleName();
        return PROPERTIES.getProperty(key);
    }

    private String getSubmoduleName() {
        return this.name().toLowerCase().replace("_", "-");
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public int getVersion() {
        return this.version;
    }

    @Generated
    public int getTotalFields() {
        return this.totalFields;
    }

    @Generated
    public Collection<Symbol> getSymbols() {
        return this.symbols;
    }

    @Generated
    public List<String> getExtensions() {
        return this.extensions;
    }

    static {
        PROPERTIES = new Properties();
        ClassLoader loader = Language.class.getClassLoader();
        try (InputStream stream = loader.getResourceAsStream("language.properties");){
            PROPERTIES.load(stream);
            PROPERTIES.entrySet().removeIf(entry -> entry.getValue().toString().isEmpty());
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex);
        }
        EXTENSION_LOOKUP = Stream.of(Language.values()).flatMap(language -> language.getExtensions().stream().map(extension -> Map.entry(extension, language))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toUnmodifiableList())));
    }

    public static final class Metadata {
        private final URL url;
        private final String sha;
        private final String tag;

        @Generated
        public URL getURL() {
            return this.url;
        }

        @Generated
        public String getSHA() {
            return this.sha;
        }

        @Generated
        public String getTag() {
            return this.tag;
        }

        @Generated
        private Metadata(URL url, String sha, String tag) {
            this.url = url;
            this.sha = sha;
            this.tag = tag;
        }
    }
}

