/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.External;
import ch.usi.si.seart.treesitter.Node;
import ch.usi.si.seart.treesitter.Point;
import ch.usi.si.seart.treesitter.Tree;
import ch.usi.si.seart.treesitter.TreeCursorNode;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class TreeCursor
extends External
implements Cloneable {
    private final int context0;
    private final int context1;
    private final long id;
    private final Tree tree;

    TreeCursor(long pointer, int context0, int context1, long id, @NotNull Tree tree) {
        super(pointer);
        this.context0 = context0;
        this.context1 = context1;
        this.id = id;
        this.tree = tree;
    }

    @Override
    protected native void delete();

    public native int getCurrentDepth();

    public native Node getCurrentNode();

    public native String getCurrentFieldName();

    public native TreeCursorNode getCurrentTreeCursorNode();

    public native boolean gotoFirstChild();

    public native boolean gotoFirstChild(int var1);

    public native boolean gotoFirstChild(@NotNull Point var1);

    public native boolean gotoNextSibling();

    public native boolean gotoParent();

    public native boolean gotoNode(@NotNull Node var1);

    public void preorderTraversal(@NotNull Consumer<Node> callback) {
        Objects.requireNonNull(callback, "Callback must not be null!");
        while (true) {
            callback.accept(this.getCurrentNode());
            if (this.gotoFirstChild() || this.gotoNextSibling()) continue;
            do {
                if (this.gotoParent()) continue;
                return;
            } while (!this.gotoNextSibling());
        }
    }

    public native boolean reset(@NotNull TreeCursor var1);

    public native TreeCursor clone();

    @Generated
    private TreeCursor() {
        this.context0 = 0;
        this.context1 = 0;
        this.id = 0L;
        this.tree = null;
    }

    static class Stub
    extends TreeCursor {
        Stub() {
        }

        @Override
        public int getCurrentDepth() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node getCurrentNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCurrentFieldName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TreeCursorNode getCurrentTreeCursorNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean gotoFirstChild() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean gotoFirstChild(int offset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean gotoFirstChild(@NotNull Point point) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean gotoNextSibling() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean gotoParent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean gotoNode(@NotNull Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void preorderTraversal(@NotNull Consumer<Node> callback) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean reset(@NotNull TreeCursor other) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TreeCursor clone() {
            throw new UnsupportedOperationException();
        }
    }
}

