/*
 * MIT License
 *
 * Copyright (c) 2022-present SEART Research Group and Contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package ch.usi.si.seart.treesitter;

import lombok.Getter;
import lombok.experimental.FieldDefaults;

import java.util.Iterator;

/**
 * Specialized iterator that can be used to generate suggestions and improve syntax error diagnostics.
 * To get symbols valid in an {@code ERROR} node, use the lookahead iterator on its first leaf node state.
 * For {@code MISSING} nodes, a lookahead iterator created on the previous non-extra leaf node may be appropriate.
 *
 * @since 1.12.0
 * @author Ozren Dabić
 */
@FieldDefaults(level = lombok.AccessLevel.PRIVATE, makeFinal = true)
public class LookaheadIterator extends External implements Iterator<Symbol> {

    boolean hasNext;

    @Getter
    Language language;

    LookaheadIterator(long pointer, boolean hasNext, Language language) {
        super(pointer);
        this.hasNext = hasNext;
        this.language = language;
    }

    @Override
    protected native void delete();

    @Override
    public boolean hasNext() {
        return hasNext;
    }

    @Override
    public native Symbol next();
}
