/*
 * MIT License
 *
 * Copyright (c) 2022-present SEART Research Group and Contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package ch.usi.si.seart.treesitter;

/**
 * Represents the {@link Capture} quantifier in a {@link Pattern},
 * i.e. the number of nodes that a capture should contain. Within a
 * query, a capture can have different quantifiers for each pattern.
 *
 * @since 1.12.0
 * @author Ozren Dabić
 */
public enum Quantifier {

    /**
     * The capture will not match any nodes,
     * as said capture is not present in a
     * specific pattern.
     */
    ZERO,
    /**
     * The capture will match at most one node.
     * Example:
     * <pre>{@code
     * ((_)? @capture)
     * }</pre>
     */
    ZERO_OR_ONE,
    /**
     * The capture will match any number of nodes.
     * Example:
     * <pre>{@code
     * ((_)* @capture)
     * }</pre>
     */
    ZERO_OR_MORE,
    /**
     * The capture will match exactly one node.
     * Example:
     * <pre>{@code
     * ((_) @capture)
     * }</pre>
     */
    ONE,
    /**
     * The capture will match at least one node.
     * Example:
     * <pre>{@code
     * ((_)+ @capture)
     * }</pre>
     */
    ONE_OR_MORE
}
