/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.Pattern;
import ch.usi.si.seart.treesitter.Quantifier;
import ch.usi.si.seart.treesitter.Query;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Capture {
    private final Query query;
    private final int index;
    private final String name;
    private boolean enabled = true;

    Capture(int index, @NotNull String name) {
        this(null, index, name);
    }

    public native void disable();

    public Quantifier getQuantifier(@NotNull Pattern pattern) {
        return this.query.getQuantifier(pattern, this);
    }

    public List<Quantifier> getQuantifiers() {
        return this.query.getPatterns().stream().map(this::getQuantifier).collect(Collectors.toUnmodifiableList());
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Capture capture = (Capture)o;
        return Objects.equals(this.query, capture.query) && this.index == capture.index;
    }

    @Generated
    public int hashCode() {
        return Objects.hash(this.query, this.index);
    }

    @Generated
    public String toString() {
        return "@" + this.name;
    }

    @Generated
    public Query getQuery() {
        return this.query;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    Capture(Query query, int index, String name) {
        this.query = query;
        this.index = index;
        this.name = name;
    }
}

