/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.exception.TreeSitterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;

public final class LibraryLoader {
    private static final String LIBRARY_FILE_NAME = "libjava-tree-sitter";

    public static void load() {
        String filename = String.format("%s.%s", LIBRARY_FILE_NAME, LibraryLoader.getExtension());
        SystemResource systemResource = new SystemResource(filename);
        String libPath = LibraryLoader.getLibPath(systemResource);
        System.load(libPath);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String getLibPath(SystemResource systemResource) {
        String protocol;
        switch (protocol = systemResource.url.getProtocol()) {
            case "file": {
                return systemResource.url.getPath();
            }
            case "jar": {
                File tmpdir = FileUtils.getTempDirectory();
                File tmpfile = new File(tmpdir, systemResource.name);
                tmpfile.deleteOnExit();
                try (InputStream input = systemResource.url.openStream();){
                    String string;
                    try (FileOutputStream output = new FileOutputStream(tmpfile, false);){
                        IOUtils.copy((InputStream)input, (OutputStream)output);
                        string = tmpfile.getPath();
                    }
                    return string;
                }
                catch (IOException cause) {
                    throw new TreeSitterException(cause);
                }
            }
        }
        UnsupportedOperationException cause = new UnsupportedOperationException("Unsupported protocol: " + protocol);
        throw new TreeSitterException(cause);
    }

    private static String getExtension() {
        if (SystemUtils.IS_OS_LINUX) {
            return "so";
        }
        if (SystemUtils.IS_OS_MAC) {
            return "dylib";
        }
        throw new TreeSitterException("The tree-sitter library was not compiled for this platform: " + SystemUtils.OS_NAME.toLowerCase());
    }

    @Generated
    private LibraryLoader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class SystemResource {
        private final URL url;
        private final String name;

        private SystemResource(String name) {
            this(LibraryLoader.class.getClassLoader().getResource(name), name);
        }

        @Generated
        private SystemResource(URL url, String name) {
            this.url = url;
            this.name = name;
        }
    }
}

