/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.Predicate;
import ch.usi.si.seart.treesitter.Query;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Pattern {
    private final Query query;
    private final int index;
    private final int startOffset;
    private final boolean rooted;
    private final boolean nonLocal;
    private final String value;
    private final List<Predicate> predicates;
    private boolean enabled = true;

    Pattern(int index, int startOffset, boolean rooted, boolean nonLocal, @NotNull String value, @NotNull Predicate[] predicates) {
        this(null, index, startOffset, rooted, nonLocal, value.stripTrailing(), List.of(predicates));
    }

    public native void disable();

    @Generated
    public int getEndOffset() {
        return this.startOffset + this.value.length();
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pattern pattern = (Pattern)o;
        return Objects.equals(this.query, pattern.query) && this.index == pattern.index;
    }

    @Generated
    public int hashCode() {
        return Objects.hash(this.query, this.index);
    }

    @Generated
    public String toString() {
        return this.value;
    }

    @Generated
    public Query getQuery() {
        return this.query;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public int getStartOffset() {
        return this.startOffset;
    }

    @Generated
    public boolean isRooted() {
        return this.rooted;
    }

    @Generated
    public boolean isNonLocal() {
        return this.nonLocal;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    Pattern(Query query, int index, int startOffset, boolean rooted, boolean nonLocal, String value, List<Predicate> predicates) {
        this.query = query;
        this.index = index;
        this.startOffset = startOffset;
        this.rooted = rooted;
        this.nonLocal = nonLocal;
        this.value = value;
        this.predicates = predicates;
    }
}

