/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.Pattern;
import java.util.List;
import lombok.Generated;

public class Predicate {
    private final Pattern pattern;
    private final List<Step> steps;

    Predicate(Pattern pattern, Step[] steps) {
        this(pattern, List.of(steps));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        block4: for (int i = 0; i < this.steps.size() - 1; ++i) {
            Step step = this.steps.get(i);
            String value = step.getValue();
            if (i == 0) {
                builder.append(value);
                continue;
            }
            builder.append(" ");
            switch (step.getType()) {
                case CAPTURE: {
                    builder.append("@").append(value);
                    continue block4;
                }
                case STRING: {
                    builder.append('\"').append(value).append('\"');
                    continue block4;
                }
            }
        }
        return "(#" + builder + ")";
    }

    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }

    @Generated
    public List<Step> getSteps() {
        return this.steps;
    }

    @Generated
    private Predicate(Pattern pattern, List<Step> steps) {
        this.pattern = pattern;
        this.steps = steps;
    }

    public static class Step {
        private final Type type;
        private final String value;

        public Step(int type, String value) {
            this(Type.get(type), value);
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        private Step(Type type, String value) {
            this.type = type;
            this.value = value;
        }

        public static enum Type {
            DONE,
            CAPTURE,
            STRING;

            private static final Type[] VALUES;

            private static Type get(int ordinal) {
                return VALUES[ordinal];
            }

            static {
                VALUES = Type.values();
            }
        }
    }
}

