/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.Capture;
import ch.usi.si.seart.treesitter.External;
import ch.usi.si.seart.treesitter.Language;
import ch.usi.si.seart.treesitter.Pattern;
import ch.usi.si.seart.treesitter.Quantifier;
import ch.usi.si.seart.treesitter.exception.query.QueryException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class Query
extends External {
    private final Language language;
    private final List<Pattern> patterns;
    private final List<Capture> captures;
    private final List<String> strings;

    Query(long pointer, @NotNull Language language, @NotNull Pattern[] patterns, @NotNull Capture[] captures, @NotNull String[] strings) {
        super(pointer);
        this.language = language;
        this.patterns = List.of(patterns);
        this.captures = List.of(captures);
        this.strings = List.of(strings);
    }

    public static Query getFor(@NotNull Language language, String ... patterns) {
        return Query.builder().language(language).patterns(patterns).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Language language = this.getLanguage();
        List<String> patterns = this.getPatterns().stream().map(Pattern::toString).collect(Collectors.toList());
        return Query.builder().language(language).patterns(patterns);
    }

    @Override
    protected native void delete();

    public boolean hasCaptures() {
        return !this.captures.isEmpty();
    }

    @Generated
    public String toString() {
        String pattern = this.getPattern();
        String capture = this.captures.stream().map(Capture::toString).collect(Collectors.joining(", ", "[", "]"));
        return String.format("Query(language: %s, pattern: '%s', captures: %s)", new Object[]{this.language, pattern, capture});
    }

    @Generated
    public String getPattern() {
        return this.patterns.stream().map(Pattern::toString).collect(Collectors.joining(" "));
    }

    Quantifier getQuantifier(@NotNull Pattern pattern, @NotNull Capture capture) {
        Objects.requireNonNull(pattern, "Pattern must not be null!");
        Objects.requireNonNull(capture, "Capture must not be null!");
        if (!this.patterns.contains(pattern)) {
            throw new IllegalArgumentException("Pattern not present in query!");
        }
        if (!this.captures.contains(capture)) {
            throw new IllegalArgumentException("Capture not present in query!");
        }
        Quantifier[] quantifiers = Quantifier.values();
        int ordinal = this.getQuantifier(pattern.getIndex(), capture.getIndex());
        return quantifiers[ordinal];
    }

    private native int getQuantifier(int var1, int var2);

    @Generated
    public Language getLanguage() {
        return this.language;
    }

    @Generated
    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    @Generated
    public List<Capture> getCaptures() {
        return this.captures;
    }

    @Generated
    public List<String> getStrings() {
        return this.strings;
    }

    public static class Builder {
        private Language language = null;
        private List<String> patterns = new ArrayList<String>();

        public Builder language(@NotNull Language language) {
            Language.validate(language);
            this.language = language;
            return this;
        }

        public Builder patterns(@NotNull @NotNull List<@NotNull String> patterns) {
            Objects.requireNonNull(patterns, "Patterns must not be null!");
            this.patterns = List.copyOf(patterns).stream().map(String::trim).collect(Collectors.toList());
            return this;
        }

        public Builder patterns(String ... patterns) {
            Objects.requireNonNull(patterns, "Patterns must not be null!");
            for (String pattern : patterns) {
                this.pattern(pattern);
            }
            return this;
        }

        public Builder pattern(@NotNull String pattern) {
            Objects.requireNonNull(pattern, "Pattern must not be null!");
            this.patterns.add(pattern.trim());
            return this;
        }

        public Builder pattern() {
            this.patterns.clear();
            return this;
        }

        public Query build() {
            Objects.requireNonNull(this.language, "Language must not be null!");
            String joined = String.join((CharSequence)" ", this.patterns);
            return Builder.build(this.language, Builder.normalize(joined));
        }

        private static String normalize(String pattern) {
            return StringUtils.normalizeSpace((String)pattern).replace(" )", ")").replace("( ", "(").replace(" ]", "]").replace("[ ", "[");
        }

        private static native Query build(Language var0, String var1) throws QueryException;

        @Generated
        private Builder() {
        }
    }
}

