/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.Node;
import ch.usi.si.seart.treesitter.Point;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Range {
    private final int startByte;
    private final int endByte;
    private final Point startPoint;
    private final Point endPoint;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Range.builder().startByte(this.startByte).endByte(this.endByte).startPoint(this.startPoint).endPoint(this.endPoint);
    }

    Range(@NotNull Node node) {
        this(node.getStartByte(), node.getEndByte(), node.getStartPoint(), node.getEndPoint());
    }

    @Generated
    public String toString() {
        return String.format("[%s] - [%s]", this.startPoint, this.endPoint);
    }

    @Generated
    public int getStartByte() {
        return this.startByte;
    }

    @Generated
    public int getEndByte() {
        return this.endByte;
    }

    @Generated
    public Point getStartPoint() {
        return this.startPoint;
    }

    @Generated
    public Point getEndPoint() {
        return this.endPoint;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartByte() != other.getStartByte()) {
            return false;
        }
        if (this.getEndByte() != other.getEndByte()) {
            return false;
        }
        Point this$startPoint = this.getStartPoint();
        Point other$startPoint = other.getStartPoint();
        if (this$startPoint == null ? other$startPoint != null : !((Object)this$startPoint).equals(other$startPoint)) {
            return false;
        }
        Point this$endPoint = this.getEndPoint();
        Point other$endPoint = other.getEndPoint();
        return !(this$endPoint == null ? other$endPoint != null : !((Object)this$endPoint).equals(other$endPoint));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Range;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStartByte();
        result = result * 59 + this.getEndByte();
        Point $startPoint = this.getStartPoint();
        result = result * 59 + ($startPoint == null ? 43 : ((Object)$startPoint).hashCode());
        Point $endPoint = this.getEndPoint();
        result = result * 59 + ($endPoint == null ? 43 : ((Object)$endPoint).hashCode());
        return result;
    }

    @Generated
    protected Range(int startByte, int endByte, Point startPoint, Point endPoint) {
        this.startByte = startByte;
        this.endByte = endByte;
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }

    public static final class Builder {
        private int startByte = 0;
        private int endByte = Integer.MAX_VALUE;
        private Point startPoint = Point.ORIGIN();
        private Point endPoint = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);

        public Builder startByte(int value) {
            if (value < 0) {
                throw new IllegalArgumentException("Start byte cannot be negative");
            }
            this.startByte = value;
            return this;
        }

        public Builder endByte(int value) {
            if (value < 0) {
                throw new IllegalArgumentException("End byte cannot be negative");
            }
            this.endByte = value;
            return this;
        }

        public Builder startPoint(@NotNull Point point) {
            Objects.requireNonNull(point, "Start point cannot be null");
            if (point.getRow() < 0 || point.getColumn() < 0) {
                throw new IllegalArgumentException("Start point cannot have negative coordinates");
            }
            this.startPoint = point;
            return this;
        }

        public Builder endPoint(@NotNull Point point) {
            Objects.requireNonNull(point, "End point cannot be null");
            if (point.getRow() < 0 || point.getColumn() < 0) {
                throw new IllegalArgumentException("End point cannot have negative coordinates");
            }
            this.endPoint = point;
            return this;
        }

        public Range build() {
            if (Integer.compareUnsigned(this.startByte, this.endByte) > 0) {
                throw new IllegalArgumentException("Start byte cannot be greater than end byte");
            }
            if (this.startPoint.compareTo(this.endPoint) > 0) {
                throw new IllegalArgumentException("Start point cannot be greater than end point");
            }
            return new Range(this.startByte, this.endByte, this.startPoint, this.endPoint);
        }

        @Generated
        private Builder() {
        }
    }
}

