/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter.printer;

import ch.usi.si.seart.treesitter.TreeCursor;
import ch.usi.si.seart.treesitter.TreeCursorNode;
import ch.usi.si.seart.treesitter.printer.IterativeTreePrinter;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class SyntaxTreePrinter
extends IterativeTreePrinter {
    public SyntaxTreePrinter(@NotNull TreeCursor cursor) {
        super(cursor);
    }

    @Override
    protected String getFileExtension() {
        return ".txt";
    }

    @Override
    protected void write(Consumer<String> appender) {
        while (true) {
            TreeCursorNode cursorNode;
            if ((cursorNode = this.cursor.getCurrentTreeCursorNode()).isNamed()) {
                int depth = this.cursor.getCurrentDepth();
                String indent = "  ".repeat(depth);
                appender.accept(indent);
                appender.accept(cursorNode.toString());
                appender.accept("\n");
            }
            if (this.cursor.gotoFirstChild() || this.cursor.gotoNextSibling()) continue;
            do {
                if (this.cursor.gotoParent()) continue;
                return;
            } while (!this.cursor.gotoNextSibling());
        }
    }
}

