/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.External;
import ch.usi.si.seart.treesitter.Language;
import ch.usi.si.seart.treesitter.Tree;
import ch.usi.si.seart.treesitter.error.ABIVersionError;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class Parser
extends External {
    private final Language language;

    public Parser(Language language) {
        super(Parser.createIfValid(language));
        this.language = language;
    }

    private static long createIfValid(Language language) {
        Language.validate(language);
        long pointer = Parser.malloc();
        Parser.setLanguage(pointer, language);
        return pointer;
    }

    static native long malloc();

    @Override
    public native void close();

    public void setLanguage(Language language) {
        Language.validate(language);
        Parser.setLanguage(this.pointer, language);
    }

    private static void setLanguage(long pointer, Language language) {
        boolean success = Parser.setLanguage(pointer, language.getId());
        if (!success) {
            throw new ABIVersionError("Language could not be assigned to parser!");
        }
    }

    static native boolean setLanguage(long var0, long var2);

    public native long getTimeout();

    public void setTimeout(Duration duration) {
        Objects.requireNonNull(duration, "Duration must not be null!");
        long micros = duration.toMillis() * TimeUnit.MILLISECONDS.toMicros(1L);
        this.setTimeout(micros);
    }

    public void setTimeout(long timeout, TimeUnit timeUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout can not be negative!");
        }
        Objects.requireNonNull(timeUnit, "Time unit must not be null!");
        long micros = timeUnit.toMicros(timeout);
        this.setTimeout(micros);
    }

    public native void setTimeout(long var1);

    public Tree parseString(String source) throws UnsupportedEncodingException {
        byte[] bytes = source.getBytes(StandardCharsets.UTF_16LE);
        long treePointer = this.parseBytes(bytes, bytes.length);
        return new Tree(treePointer, this.language);
    }

    native long parseBytes(byte[] var1, int var2);

    public Tree parseString(String source, Tree oldTree) throws UnsupportedEncodingException {
        byte[] bytes = source.getBytes(StandardCharsets.UTF_16LE);
        long treePointer = this.parseBytes(bytes, bytes.length, oldTree);
        return new Tree(treePointer, this.language);
    }

    native long parseBytes(byte[] var1, int var2, Tree var3);

    public Tree parseFile(Path path) throws IOException {
        String source = Files.readString(path);
        return this.parseString(source);
    }

    @Generated
    public String toString() {
        return String.format("Parser(id: %d, language: %s)", new Object[]{this.pointer, this.language});
    }

    @Generated
    public Language getLanguage() {
        return this.language;
    }
}

