/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter.printer;

import ch.usi.si.seart.treesitter.Tree;
import ch.usi.si.seart.treesitter.printer.TreePrinter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public class DotGraphPrinter
implements TreePrinter {
    Tree tree;

    public DotGraphPrinter(Tree tree) {
        this.tree = Objects.requireNonNull(tree, "Tree must not be null!");
    }

    @Override
    public String print() {
        try {
            File file = this.export();
            Path path = file.toPath();
            String contents = Files.readString(path);
            Files.delete(path);
            return contents;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public File export() throws IOException {
        File file = Files.createTempFile("ts-export-", ".dot", new FileAttribute[0]).toFile();
        this.write(file);
        return file;
    }

    native void write(File var1) throws IOException;
}

