/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter.printer;

import ch.usi.si.seart.treesitter.TreeCursor;
import ch.usi.si.seart.treesitter.TreeCursorNode;
import ch.usi.si.seart.treesitter.function.IOExceptionThrowingConsumer;
import ch.usi.si.seart.treesitter.printer.IterativeTreePrinter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.function.Consumer;

public class SyntaxTreePrinter
extends IterativeTreePrinter {
    private int depth = 0;

    public SyntaxTreePrinter(TreeCursor cursor) {
        super(cursor);
    }

    @Override
    public String print() {
        StringBuilder stringBuilder = new StringBuilder();
        this.write(stringBuilder::append);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File export() throws IOException {
        File file = Files.createTempFile("ts-export-", ".txt", new FileAttribute[0]).toFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            Consumer<String> appender = IOExceptionThrowingConsumer.toUnchecked(writer::append);
            try {
                this.write(appender);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
            File file2 = file;
            return file2;
        }
        finally {
            if (Collections.singletonList(writer).get(0) != null) {
                ((Writer)writer).close();
            }
        }
    }

    private void write(Consumer<String> appender) {
        while (true) {
            TreeCursorNode cursorNode;
            if ((cursorNode = this.cursor.getCurrentTreeCursorNode()).isNamed()) {
                String indent = "  ".repeat(this.depth);
                appender.accept(indent);
                appender.accept(cursorNode.toString());
                appender.accept("\n");
            }
            if (this.cursor.gotoFirstChild()) {
                ++this.depth;
                continue;
            }
            if (this.cursor.gotoNextSibling()) continue;
            do {
                if (this.cursor.gotoParent()) {
                    --this.depth;
                    continue;
                }
                return;
            } while (!this.cursor.gotoNextSibling());
        }
    }
}

