/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.Node;
import ch.usi.si.seart.treesitter.Point;
import ch.usi.si.seart.treesitter.Range;
import ch.usi.si.seart.treesitter.TreeCursor;
import ch.usi.si.seart.treesitter.TreeCursorNode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class OffsetTreeCursor
extends TreeCursor {
    private final Point offset;

    public OffsetTreeCursor(Node node, Point offset) {
        super(node);
        Objects.requireNonNull(offset, "Offset must not be null!");
        this.offset = offset;
    }

    @Override
    public Node getCurrentNode() {
        return new OffsetNode(super.getCurrentNode());
    }

    @Override
    public TreeCursorNode getCurrentTreeCursorNode() {
        return new OffsetTreeCursorNode(super.getCurrentTreeCursorNode(), this.offset);
    }

    private static class PositionOnlyRange
    extends Range {
        PositionOnlyRange(Node node) {
            super(Integer.MIN_VALUE, Integer.MAX_VALUE, node.getStartPoint(), node.getEndPoint());
        }

        @Override
        public int getEndByte() {
            throw new UnsupportedOperationException("Byte positions not available!");
        }

        @Override
        public int getStartByte() {
            throw new UnsupportedOperationException("Byte positions not available!");
        }
    }

    private static class OffsetTreeCursorNode
    extends TreeCursorNode {
        OffsetTreeCursorNode(TreeCursorNode cursorNode, Point offset) {
            this(cursorNode.getType(), cursorNode.getName(), new Point(cursorNode.getStartPoint().getRow() + offset.getRow(), cursorNode.getStartPoint().getColumn() + offset.getColumn()), new Point(cursorNode.getEndPoint().getRow() + offset.getRow(), cursorNode.getEndPoint().getColumn() + offset.getColumn()), cursorNode.isNamed());
        }

        OffsetTreeCursorNode(String type, String name, Point startPoint, Point endPoint, boolean isNamed) {
            super(type, name, Integer.MIN_VALUE, Integer.MAX_VALUE, startPoint, endPoint, isNamed);
        }

        @Override
        public int getEndByte() {
            throw new UnsupportedOperationException("Byte positions not available after node position has changed!");
        }

        @Override
        public int getStartByte() {
            throw new UnsupportedOperationException("Byte positions not available after node position has changed!");
        }
    }

    private class OffsetNode
    extends Node {
        private final Node node;

        OffsetNode(Node node) {
            this.node = node;
        }

        @Override
        public Node getChild(int child) {
            return new OffsetNode(super.getChild(child));
        }

        @Override
        public Node getChildByFieldName(@NotNull String name) {
            return new OffsetNode(super.getChildByFieldName(name));
        }

        @Override
        public List<Node> getChildren() {
            return super.getChildren().stream().map(x$0 -> new OffsetNode((Node)x$0)).collect(Collectors.toList());
        }

        @Override
        public Node getDescendantForByteRange(int startByte, int endByte) {
            throw new UnsupportedOperationException("Byte position searches not supported after node position has changed!");
        }

        @Override
        public int getEndByte() {
            throw new UnsupportedOperationException("Byte positions not available after node position has changed!");
        }

        @Override
        public Point getEndPoint() {
            Point point = this.node.getEndPoint();
            return new Point(point.getRow() + OffsetTreeCursor.this.offset.getRow(), point.getColumn() + OffsetTreeCursor.this.offset.getColumn());
        }

        @Override
        public Node getFirstChildForByte(int offset) {
            throw new UnsupportedOperationException("Byte position searches not supported after node position has changed!");
        }

        @Override
        public Node getFirstNamedChildForByte(int offset) {
            throw new UnsupportedOperationException("Byte position searches not supported after node position has changed!");
        }

        @Override
        public Node getNextNamedSibling() {
            return new OffsetNode(super.getNextNamedSibling());
        }

        @Override
        public Node getNextSibling() {
            return new OffsetNode(super.getNextSibling());
        }

        @Override
        public Node getPrevNamedSibling() {
            return new OffsetNode(super.getPrevNamedSibling());
        }

        @Override
        public Node getPrevSibling() {
            return new OffsetNode(super.getPrevSibling());
        }

        @Override
        public Node getParent() {
            return new OffsetNode(super.getParent());
        }

        @Override
        public Range getRange() {
            return new PositionOnlyRange(this);
        }

        @Override
        public int getStartByte() {
            throw new UnsupportedOperationException("Byte positions not available after node position has changed!");
        }

        @Override
        public Point getStartPoint() {
            Point point = this.node.getStartPoint();
            return new Point(point.getRow() + OffsetTreeCursor.this.offset.getRow(), point.getColumn() + OffsetTreeCursor.this.offset.getColumn());
        }

        @Override
        public TreeCursor walk() {
            return new OffsetTreeCursor(this.node, OffsetTreeCursor.this.offset);
        }
    }
}

