/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter.printer;

import ch.usi.si.seart.treesitter.Point;
import ch.usi.si.seart.treesitter.TreeCursor;
import ch.usi.si.seart.treesitter.TreeCursorNode;
import ch.usi.si.seart.treesitter.function.IOExceptionThrowingConsumer;
import ch.usi.si.seart.treesitter.printer.IterativeTreePrinter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class XMLPrinter
extends IterativeTreePrinter {
    public static final String PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private boolean visitedChildren = false;
    private final Deque<String> tags = new ArrayDeque<String>();

    public XMLPrinter(@NotNull TreeCursor cursor) {
        super(cursor);
    }

    @Override
    public String print() {
        StringBuilder stringBuilder = new StringBuilder(PROLOG);
        this.write(stringBuilder::append);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File export() throws IOException {
        File file = Files.createTempFile("ts-export-", ".xml", new FileAttribute[0]).toFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            writer.append(PROLOG);
            Consumer<String> appender = IOExceptionThrowingConsumer.toUnchecked(writer::append);
            try {
                this.write(appender);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
            File file2 = file;
            return file2;
        }
        finally {
            if (Collections.singletonList(writer).get(0) != null) {
                ((Writer)writer).close();
            }
        }
    }

    private void write(Consumer<String> appender) {
        while (true) {
            TreeCursorNode cursorNode = this.cursor.getCurrentTreeCursorNode();
            boolean isNamed = cursorNode.isNamed();
            String type = cursorNode.getType();
            String name = cursorNode.getName();
            Point start = cursorNode.getStartPoint();
            Point end = cursorNode.getEndPoint();
            if (this.visitedChildren) {
                if (isNamed) {
                    appender.accept("</");
                    appender.accept(this.tags.pop());
                    appender.accept(">");
                }
                if (this.cursor.gotoNextSibling()) {
                    this.visitedChildren = false;
                    continue;
                }
                if (this.cursor.gotoParent()) {
                    this.visitedChildren = true;
                    continue;
                }
                return;
            }
            if (isNamed) {
                appender.accept("<");
                appender.accept(type);
                appender.accept(" ");
                if (name != null) {
                    appender.accept("name=\"");
                    appender.accept(name);
                    appender.accept("\" ");
                }
                appender.accept("start=\"");
                appender.accept(start.toString());
                appender.accept("\" ");
                appender.accept("end=\"");
                appender.accept(end.toString());
                appender.accept("\">");
                this.tags.push(type);
            }
            this.visitedChildren = !this.cursor.gotoFirstChild();
        }
    }
}

