/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import java.util.Objects;
import lombok.Generated;

public enum Language {
    _INVALID_,
    AGDA(Language.agda()),
    BASH(Language.bash()),
    C(Language.c()),
    CSHARP(Language.cSharp()),
    CPP(Language.cpp()),
    CSS(Language.css()),
    DART(Language.dart()),
    ELM(Language.elm()),
    EMBEDDED_TEMPLATE(Language.embeddedTemplate()),
    ENO(Language.eno()),
    GO(Language.go()),
    HASKELL(Language.haskell()),
    HTML(Language.html()),
    JAVA(Language.java()),
    JAVASCRIPT(Language.javascript()),
    JULIA(Language.julia()),
    KOTLIN(Language.kotlin()),
    LUA(Language.lua()),
    MARKDOWN(Language.markdown()),
    OCAML(Language.ocaml()),
    PHP(Language.php()),
    PYTHON(Language.python()),
    RUBY(Language.ruby()),
    RUST(Language.rust()),
    SCALA(Language.scala()),
    SCSS(Language.scss()),
    SWIFT(Language.swift()),
    TOML(Language.toml()),
    TSX(Language.tsx()),
    TYPESCRIPT(Language.typescript()),
    VUE(Language.vue()),
    YAML(Language.yaml()),
    WASM(Language.wasm());

    private final long id;
    private static final long INVALID = 0L;

    private static native long agda();

    private static native long bash();

    private static native long c();

    private static native long cSharp();

    private static native long cpp();

    private static native long css();

    private static native long dart();

    private static native long elm();

    private static native long embeddedTemplate();

    private static native long eno();

    private static native long go();

    private static native long haskell();

    private static native long html();

    private static native long java();

    private static native long javascript();

    private static native long julia();

    private static native long kotlin();

    private static native long lua();

    private static native long markdown();

    private static native long ocaml();

    private static native long php();

    private static native long python();

    private static native long ruby();

    private static native long rust();

    private static native long scala();

    private static native long scss();

    private static native long swift();

    private static native long toml();

    private static native long tsx();

    private static native long typescript();

    private static native long vue();

    private static native long yaml();

    private static native long wasm();

    public static void validate(Language language) {
        Objects.requireNonNull(language, "Language must not be null!");
        long id = language.getId();
        if (id == 0L) {
            throw new UnsatisfiedLinkError("Language binding has not been defined for: " + language);
        }
    }

    private Language() {
        this(0L);
    }

    public String toString() {
        switch (this) {
            case C: 
            case CSS: 
            case HTML: 
            case PHP: 
            case SCSS: 
            case TOML: 
            case TSX: 
            case YAML: {
                return this.name();
            }
            case AGDA: 
            case BASH: 
            case DART: 
            case ELM: 
            case ENO: 
            case GO: 
            case HASKELL: 
            case JAVA: 
            case JULIA: 
            case KOTLIN: 
            case LUA: 
            case MARKDOWN: 
            case PYTHON: 
            case RUBY: 
            case RUST: 
            case SCALA: 
            case SWIFT: 
            case VUE: {
                return this.name().charAt(0) + this.name().substring(1).toLowerCase();
            }
            case CSHARP: {
                return "C#";
            }
            case CPP: {
                return "C++";
            }
            case EMBEDDED_TEMPLATE: {
                return "Embedded Template";
            }
            case JAVASCRIPT: {
                return "JavaScript";
            }
            case OCAML: {
                return "OCaml";
            }
            case TYPESCRIPT: {
                return "TypeScript";
            }
            case WASM: {
                return "WebAssembly";
            }
        }
        return "???";
    }

    @Generated
    long getId() {
        return this.id;
    }

    @Generated
    private Language(long id) {
        this.id = id;
    }
}

