/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.External;
import ch.usi.si.seart.treesitter.Language;
import ch.usi.si.seart.treesitter.Tree;
import ch.usi.si.seart.treesitter.error.ABIVersionError;
import ch.usi.si.seart.treesitter.exception.ParsingException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Parser
extends External {
    private final Language language;
    private static final Charset CHARSET = StandardCharsets.UTF_16LE;

    public Parser(@NotNull Language language) {
        super(Parser.createIfValid(language));
        this.language = language;
    }

    private static long createIfValid(Language language) {
        Language.validate(language);
        long pointer = Parser.malloc();
        Parser.setLanguage(pointer, language);
        return pointer;
    }

    private static native long malloc();

    @Override
    public native void close();

    public void setLanguage(@NotNull Language language) {
        Language.validate(language);
        Parser.setLanguage(this.pointer, language);
    }

    private static void setLanguage(long pointer, Language language) {
        boolean success = Parser.setLanguage(pointer, language.getId());
        if (!success) {
            throw new ABIVersionError("Language could not be assigned to parser!");
        }
    }

    private static native boolean setLanguage(long var0, long var2);

    public native long getTimeout();

    public void setTimeout(@NotNull Duration duration) {
        Objects.requireNonNull(duration, "Duration must not be null!");
        long micros = duration.toMillis() * TimeUnit.MILLISECONDS.toMicros(1L);
        this.setTimeout(micros);
    }

    public void setTimeout(long timeout, @NotNull TimeUnit timeUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout can not be negative!");
        }
        Objects.requireNonNull(timeUnit, "Time unit must not be null!");
        long micros = timeUnit.toMicros(timeout);
        this.setTimeout(micros);
    }

    public native void setTimeout(long var1);

    @Deprecated(since="1.3.0", forRemoval=true)
    public Tree parseString(@NotNull String source) throws UnsupportedEncodingException {
        return this.parse(source);
    }

    public Tree parse(@NotNull String source) throws ParsingException {
        byte[] bytes = source.getBytes(CHARSET);
        return this.parse(bytes, bytes.length, null);
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public Tree parseString(@NotNull String source, @NotNull Tree oldTree) throws UnsupportedEncodingException {
        return this.parse(source, oldTree);
    }

    public Tree parse(@NotNull String source, @NotNull Tree oldTree) throws ParsingException {
        byte[] bytes = source.getBytes(CHARSET);
        return this.parse(bytes, bytes.length, oldTree);
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public Tree parseFile(@NotNull Path path) throws IOException {
        String source = Files.readString(path);
        return this.parseString(source);
    }

    public Tree parse(@NotNull Path path) throws ParsingException {
        try {
            String source = Files.readString(path);
            return this.parse(source);
        }
        catch (IOException ex) {
            throw new ParsingException(ex);
        }
    }

    public Tree parse(@NotNull Path path, @NotNull Tree oldTree) throws ParsingException {
        try {
            String source = Files.readString(path);
            return this.parse(source, oldTree);
        }
        catch (IOException ex) {
            throw new ParsingException(ex);
        }
    }

    private native Tree parse(byte[] var1, int var2, Tree var3);

    @Generated
    public String toString() {
        return String.format("Parser(id: %d, language: %s)", new Object[]{this.pointer, this.language});
    }

    @Generated
    public Language getLanguage() {
        return this.language;
    }
}

