/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter.printer;

import ch.usi.si.seart.treesitter.TreeCursor;
import ch.usi.si.seart.treesitter.function.IOExceptionThrowingConsumer;
import ch.usi.si.seart.treesitter.printer.TreePrinter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

abstract class IterativeTreePrinter
implements TreePrinter {
    protected final TreeCursor cursor;

    protected IterativeTreePrinter(@NotNull TreeCursor cursor) {
        this.cursor = Objects.requireNonNull(cursor, "Cursor must not be null!");
    }

    @Override
    public final String print() {
        StringBuilder stringBuilder = new StringBuilder(this.getPreamble());
        this.write(stringBuilder::append);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final File export() throws IOException {
        File file = Files.createTempFile("ts-export-", this.getFileExtension(), new FileAttribute[0]).toFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            writer.append(this.getPreamble());
            Consumer<String> appender = IOExceptionThrowingConsumer.toUnchecked(writer::append);
            try {
                this.write(appender);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
            File file2 = file;
            return file2;
        }
        finally {
            if (Collections.singletonList(writer).get(0) != null) {
                ((Writer)writer).close();
            }
        }
    }

    protected String getPreamble() {
        return "";
    }

    protected String getFileExtension() {
        return "";
    }

    protected abstract void write(Consumer<String> var1);
}

