/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.Point;
import ch.usi.si.seart.treesitter.Range;
import ch.usi.si.seart.treesitter.TreeCursor;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Node
implements Iterable<Node> {
    private final int context0;
    private final int context1;
    private final int context2;
    private final int context3;
    private final long id;
    private final long tree;

    Node() {
        this(0, 0, 0, 0, 0L, 0L);
    }

    public native Node getChild(int var1);

    public native Node getChildByFieldName(@NotNull String var1);

    public native int getChildCount();

    public List<Node> getChildren() {
        return IntStream.range(0, this.getChildCount()).mapToObj(this::getChild).collect(Collectors.toList());
    }

    public native Node getDescendantForByteRange(int var1, int var2);

    public native int getEndByte();

    public native Point getEndPoint();

    public native String getFieldNameForChild(int var1);

    public native Node getFirstChildForByte(int var1);

    public native Node getFirstNamedChildForByte(int var1);

    @Deprecated(since="1.4.0", forRemoval=true)
    public native String getNodeString();

    public native Node getNextNamedSibling();

    public native Node getNextSibling();

    public native Node getPrevNamedSibling();

    public native Node getPrevSibling();

    public native Node getParent();

    public Range getRange() {
        return new Range(this);
    }

    public native int getStartByte();

    public native Point getStartPoint();

    public native String getType();

    public native boolean hasError();

    public native boolean isExtra();

    public native boolean isMissing();

    public native boolean isNamed();

    public native boolean isNull();

    public TreeCursor walk() {
        return new TreeCursor(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return Node.equals(this, other);
    }

    private static native boolean equals(@NotNull Node var0, @NotNull Node var1);

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    @Generated
    public String toString() {
        return String.format("Node(id: %d, tree: %d)", this.id, this.tree);
    }

    @Override
    @NotNull
    public Iterator<Node> iterator() {
        return new Iterator<Node>(){
            private final Deque<Node> stack;
            {
                this.stack = new ArrayDeque<Node>(List.of(Node.this));
            }

            @Override
            public boolean hasNext() {
                return !this.stack.isEmpty();
            }

            @Override
            public Node next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Node node = this.stack.pop();
                this.stack.addAll(node.getChildren());
                return node;
            }
        };
    }

    @Generated
    Node(int context0, int context1, int context2, int context3, long id, long tree) {
        this.context0 = context0;
        this.context1 = context1;
        this.context2 = context2;
        this.context3 = context3;
        this.id = id;
        this.tree = tree;
    }
}

