/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter.printer;

import ch.usi.si.seart.treesitter.TreeCursor;
import ch.usi.si.seart.treesitter.TreeCursorNode;
import ch.usi.si.seart.treesitter.printer.IterativeTreePrinter;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class SymbolicExpressionPrinter
extends IterativeTreePrinter {
    public SymbolicExpressionPrinter(@NotNull TreeCursor cursor) {
        super(cursor);
    }

    @Override
    protected String getFileExtension() {
        return ".scm";
    }

    @Override
    protected void write(Consumer<String> appender) {
        boolean needsSpace = false;
        boolean visitedChildren = false;
        while (true) {
            TreeCursorNode cursorNode = this.cursor.getCurrentTreeCursorNode();
            boolean isNamed = cursorNode.isNamed();
            String type = cursorNode.getType();
            String name = cursorNode.getName();
            if (visitedChildren) {
                if (isNamed) {
                    appender.accept(")");
                    needsSpace = true;
                }
                if (this.cursor.gotoNextSibling()) {
                    visitedChildren = false;
                    continue;
                }
                if (this.cursor.gotoParent()) {
                    visitedChildren = true;
                    continue;
                }
                return;
            }
            if (isNamed) {
                if (needsSpace) {
                    appender.accept(" ");
                }
                if (name != null) {
                    appender.accept(name);
                    appender.accept(": ");
                }
                appender.accept("(");
                appender.accept(type);
                needsSpace = true;
            }
            visitedChildren = !this.cursor.gotoFirstChild();
        }
    }
}

