/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.External;
import ch.usi.si.seart.treesitter.Node;
import ch.usi.si.seart.treesitter.Query;
import ch.usi.si.seart.treesitter.QueryMatch;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class QueryCursor
extends External
implements Iterable<QueryMatch> {
    private final Node node;
    private final Query query;
    private boolean executed = false;

    public QueryCursor(@NotNull Node node, @NotNull Query query) {
        super(QueryCursor.createIfValid(node, query));
        this.node = node;
        this.query = query;
    }

    private static long createIfValid(Node node, Query query) {
        Objects.requireNonNull(node, "Node must not be null!");
        Objects.requireNonNull(query, "Query must not be null!");
        return QueryCursor.malloc();
    }

    private static native long malloc();

    @Override
    public native void close();

    public native void execute();

    public native QueryMatch nextMatch();

    @Override
    @NotNull
    public Iterator<QueryMatch> iterator() {
        this.execute();
        return new Iterator<QueryMatch>(){
            private QueryMatch current;
            {
                this.current = QueryCursor.this.nextMatch();
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public QueryMatch next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                QueryMatch match = this.current;
                this.current = QueryCursor.this.nextMatch();
                return match;
            }
        };
    }

    @Generated
    public String toString() {
        return String.format("QueryCursor(node: %s, query: %s)", this.node, this.query);
    }
}

