/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.External;
import ch.usi.si.seart.treesitter.Node;
import ch.usi.si.seart.treesitter.TreeCursorNode;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class TreeCursor
extends External {
    private int context0;
    private int context1;
    private long id;
    private long tree;

    TreeCursor(@NotNull Node node) {
        super(TreeCursor.malloc(node));
    }

    private static native long malloc(Node var0);

    @Override
    public native void close();

    public native Node getCurrentNode();

    public native String getCurrentFieldName();

    public native TreeCursorNode getCurrentTreeCursorNode();

    public native boolean gotoFirstChild();

    public native boolean gotoNextSibling();

    public native boolean gotoParent();

    public void preorderTraversal(@NotNull Consumer<Node> callback) {
        Objects.requireNonNull(callback, "Callback must not be null!");
        while (true) {
            callback.accept(this.getCurrentNode());
            if (this.gotoFirstChild() || this.gotoNextSibling()) continue;
            do {
                if (this.gotoParent()) continue;
                return;
            } while (!this.gotoNextSibling());
        }
    }

    @Generated
    public String toString() {
        return String.format("TreeCursor(id: %d, tree: %d)", this.id, this.tree);
    }
}

