/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.Node;
import ch.usi.si.seart.treesitter.Point;
import ch.usi.si.seart.treesitter.Query;
import ch.usi.si.seart.treesitter.QueryCursor;
import ch.usi.si.seart.treesitter.Range;
import ch.usi.si.seart.treesitter.TreeCursor;
import ch.usi.si.seart.treesitter.TreeCursorNode;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class OffsetTreeCursor
extends TreeCursor {
    private final TreeCursor cursor;
    private final Point offset;

    public OffsetTreeCursor(@NotNull Node node, @NotNull Point offset) {
        Objects.requireNonNull(node, "Node must not be null!");
        Objects.requireNonNull(offset, "Offset must not be null!");
        this.cursor = node.walk();
        this.offset = offset;
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public String getCurrentFieldName() {
        return this.cursor.getCurrentFieldName();
    }

    @Override
    public boolean gotoFirstChild() {
        return this.cursor.gotoFirstChild();
    }

    @Override
    public boolean gotoNextSibling() {
        return this.cursor.gotoNextSibling();
    }

    @Override
    public boolean gotoParent() {
        return this.cursor.gotoParent();
    }

    @Override
    public void preorderTraversal(@NotNull Consumer<Node> callback) {
        this.cursor.preorderTraversal(callback);
    }

    @Override
    public Node getCurrentNode() {
        return new OffsetNode(this.cursor.getCurrentNode());
    }

    @Override
    public TreeCursorNode getCurrentTreeCursorNode() {
        return new OffsetTreeCursorNode(this.cursor.getCurrentTreeCursorNode(), this.offset);
    }

    private static class PositionOnlyRange
    extends Range {
        PositionOnlyRange(Node node) {
            super(Integer.MIN_VALUE, Integer.MAX_VALUE, node.getStartPoint(), node.getEndPoint());
        }

        @Override
        public int getEndByte() {
            throw new UnsupportedOperationException("Byte positions not available!");
        }

        @Override
        public int getStartByte() {
            throw new UnsupportedOperationException("Byte positions not available!");
        }
    }

    private static class OffsetTreeCursorNode
    extends TreeCursorNode {
        OffsetTreeCursorNode(TreeCursorNode cursorNode, Point offset) {
            this(cursorNode.getName(), cursorNode.getType(), cursorNode.getContent(), new Point(cursorNode.getStartPoint().getRow() + offset.getRow(), cursorNode.getStartPoint().getColumn() + offset.getColumn()), new Point(cursorNode.getEndPoint().getRow() + offset.getRow(), cursorNode.getEndPoint().getColumn() + offset.getColumn()), cursorNode.isNamed());
        }

        OffsetTreeCursorNode(String name, String type, String content, Point startPoint, Point endPoint, boolean isNamed) {
            super(name, type, content, Integer.MIN_VALUE, Integer.MAX_VALUE, startPoint, endPoint, isNamed);
        }

        @Override
        public int getEndByte() {
            throw new UnsupportedOperationException("Byte positions not available after node position has changed!");
        }

        @Override
        public int getStartByte() {
            throw new UnsupportedOperationException("Byte positions not available after node position has changed!");
        }
    }

    private class OffsetNode
    extends Node {
        private final Node node;

        @Override
        public Node getChild(int child) {
            return new OffsetNode(this.node.getChild(child));
        }

        @Override
        public Node getChildByFieldName(@NotNull String name) {
            return new OffsetNode(this.node.getChildByFieldName(name));
        }

        @Override
        public List<Node> getChildren() {
            return this.node.getChildren().stream().map(x$0 -> new OffsetNode((Node)x$0)).collect(Collectors.toList());
        }

        @Override
        public String getContent() {
            return this.node.getContent();
        }

        @Override
        public Node getDescendantForByteRange(int startByte, int endByte) {
            throw new UnsupportedOperationException("Byte position searches not supported after node position has changed!");
        }

        @Override
        public int getEndByte() {
            throw new UnsupportedOperationException("Byte positions not available after node position has changed!");
        }

        @Override
        public Point getEndPoint() {
            Point point = this.node.getEndPoint();
            return new Point(point.getRow() + OffsetTreeCursor.this.offset.getRow(), point.getColumn() + OffsetTreeCursor.this.offset.getColumn());
        }

        @Override
        public Node getFirstChildForByte(int offset) {
            throw new UnsupportedOperationException("Byte position searches not supported after node position has changed!");
        }

        @Override
        public Node getFirstNamedChildForByte(int offset) {
            throw new UnsupportedOperationException("Byte position searches not supported after node position has changed!");
        }

        @Override
        public Node getNextNamedSibling() {
            return new OffsetNode(this.node.getNextNamedSibling());
        }

        @Override
        public Node getNextSibling() {
            return new OffsetNode(this.node.getNextSibling());
        }

        @Override
        public Node getPrevNamedSibling() {
            return new OffsetNode(this.node.getPrevNamedSibling());
        }

        @Override
        public Node getPrevSibling() {
            return new OffsetNode(this.node.getPrevSibling());
        }

        @Override
        public Node getParent() {
            return new OffsetNode(this.node.getParent());
        }

        @Override
        public Range getRange() {
            return new PositionOnlyRange(this);
        }

        @Override
        public int getStartByte() {
            throw new UnsupportedOperationException("Byte positions not available after node position has changed!");
        }

        @Override
        public Point getStartPoint() {
            Point point = this.node.getStartPoint();
            return new Point(point.getRow() + OffsetTreeCursor.this.offset.getRow(), point.getColumn() + OffsetTreeCursor.this.offset.getColumn());
        }

        @Override
        public TreeCursor walk() {
            return new OffsetTreeCursor(this.node, OffsetTreeCursor.this.offset);
        }

        @Override
        public QueryCursor walk(@NotNull Query query) {
            throw new UnsupportedOperationException("Querying not available after node position has changed!");
        }

        @Generated
        OffsetNode(Node node) {
            this.node = node;
        }
    }
}

