/*
 * MIT License
 *
 * Copyright (c) 2022-present SEART Research Group and Contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package ch.usi.si.seart.treesitter.printer;

import java.io.File;
import java.io.IOException;

/**
 * Contract for classes that can generate string
 * representations of Abstract Syntax Trees (ASTs).
 * Implementations of this interface are responsible
 * for traversing trees and producing a specific representation.
 *
 * @since 1.2.0
 * @author Ozren Dabić
 */
public interface TreePrinter {

    /**
     * Generates a string representation of an Abstract Syntax Tree (AST).
     *
     * @return A string representation of the tree
     */
    String print();

    /**
     * Generates a file containing the string
     * representation of an Abstract Syntax Tree (AST).
     * This method should be preferred over {@link #print()}
     * when dealing with extremely wide, or deep trees.
     *
     * @return A file containing the string representation of the tree
     * @throws IOException if an I/O error occurs
     */
    File export() throws IOException;
}
