/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.exception.TreeSitterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import lombok.Generated;

public final class LibraryLoader {
    public static void load() {
        String name = "libjava-tree-sitter";
        String extension = LibraryLoader.getExtension();
        String filename = name + "." + extension;
        SystemResource systemResource = new SystemResource(filename);
        String libPath = LibraryLoader.getLibPath(systemResource);
        System.load(libPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    private static String getLibPath(SystemResource systemResource) {
        var2_2 = protocol = systemResource.url.getProtocol();
        var3_3 = -1;
        switch (var2_2.hashCode()) {
            case 3143036: {
                if (!var2_2.equals("file")) break;
                var3_3 = 0;
                break;
            }
            case 104987: {
                if (!var2_2.equals("jar")) break;
                var3_3 = 1;
            }
        }
        switch (var3_3) {
            case 0: {
                return systemResource.url.getPath();
            }
            case 1: {
                try {
                    input = systemResource.url.openStream();
                    try {
                        tmpdir = System.getProperty("java.io.tmpdir");
                        temporary = new File(tmpdir, systemResource.name);
                        temporary.deleteOnExit();
                        output = new FileOutputStream(temporary, false);
                        try {
                            input.transferTo(output);
                            var8_10 = temporary.getPath();
                            if (Collections.singletonList(output).get(0) == null) ** GOTO lbl35
                        }
                        catch (Throwable var9_11) {
                            if (Collections.singletonList(output).get(0) != null) {
                                output.close();
                            }
                            throw var9_11;
                        }
                        output.close();
lbl35:
                        // 2 sources

                        return var8_10;
                    }
                    finally {
                        if (Collections.singletonList(input).get(0) != null) {
                            input.close();
                        }
                    }
                }
                catch (IOException cause) {
                    throw new TreeSitterException(cause);
                }
            }
        }
        cause = new UnsupportedOperationException("Unsupported protocol: " + protocol);
        throw new TreeSitterException(cause);
    }

    private static String getExtension() {
        String platform = System.getProperty("os.name").toLowerCase();
        if (platform.contains("nix") || platform.contains("nux") || platform.contains("aix")) {
            return "so";
        }
        if (platform.contains("mac") || platform.contains("darwin")) {
            return "dylib";
        }
        throw new TreeSitterException("The tree-sitter library was not compiled for this platform: " + platform);
    }

    @Generated
    private LibraryLoader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class SystemResource {
        private final URL url;
        private final String name;

        private SystemResource(String name) {
            this(LibraryLoader.class.getClassLoader().getResource(name), name);
        }

        @Generated
        private SystemResource(URL url, String name) {
            this.url = url;
            this.name = name;
        }
    }
}

