/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.External;
import ch.usi.si.seart.treesitter.Language;
import ch.usi.si.seart.treesitter.QueryCapture;
import ch.usi.si.seart.treesitter.exception.query.QueryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Query
extends External {
    private final Language language;
    private final String pattern;
    private final List<String> captures;

    public Query(@NotNull Language language, @NotNull String pattern) {
        super(Query.createIfValid(language, pattern));
        this.language = language;
        this.pattern = pattern;
        int capturesCount = Query.countCaptures(this.pointer);
        ArrayList<String> captures = new ArrayList<String>(capturesCount);
        for (int idx = 0; idx < capturesCount; ++idx) {
            String capture = Query.getCaptureName(this.pointer, idx);
            captures.add(capture);
        }
        this.captures = Collections.unmodifiableList(captures);
    }

    private static long createIfValid(Language language, String pattern) {
        Language.validate(language);
        Objects.requireNonNull(pattern, "Pattern must not be null!");
        return Query.malloc(language.getId(), pattern);
    }

    private static native long malloc(long var0, String var2) throws QueryException;

    @Override
    public native void close();

    public native int countStrings();

    public native int countCaptures();

    private static native int countCaptures(long var0);

    public native int countPatterns();

    public String getCaptureName(@NotNull QueryCapture capture) {
        return this.captures.get(capture.getIndex());
    }

    private static native String getCaptureName(long var0, int var2);

    public boolean hasCaptures() {
        return !this.captures.isEmpty();
    }

    @Generated
    public String toString() {
        return String.format("Query(language: %s, pattern: '%s', captures: [%s])", new Object[]{this.language, this.pattern, String.join((CharSequence)", ", this.captures)});
    }

    @Generated
    public Language getLanguage() {
        return this.language;
    }

    @Generated
    public String getPattern() {
        return this.pattern;
    }

    @Generated
    public List<String> getCaptures() {
        return this.captures;
    }
}

