/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.External;
import ch.usi.si.seart.treesitter.InputEdit;
import ch.usi.si.seart.treesitter.Language;
import ch.usi.si.seart.treesitter.Node;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Tree
extends External
implements Iterable<Node>,
Cloneable {
    private static final Charset CHARSET = StandardCharsets.UTF_16LE;
    private final Language language;
    private final String source;

    Tree(long pointer, @NotNull Language language, @NotNull String source) {
        super(pointer);
        this.language = language;
        this.source = source;
    }

    @Override
    public native void close();

    public native void edit(@NotNull InputEdit var1);

    public native Node getRootNode();

    @Override
    @NotNull
    public Iterator<Node> iterator() {
        return this.getRootNode().iterator();
    }

    public native Tree clone();

    @Generated
    public String toString() {
        return String.format("Tree(id: %d, language: %s)", new Object[]{this.pointer, this.language});
    }

    String getSource(int startByte, int endByte) {
        byte[] bytes = this.source.getBytes(CHARSET);
        byte[] copy = Arrays.copyOfRange(bytes, startByte * 2, endByte * 2);
        return new String(copy, CHARSET);
    }

    @Generated
    public Language getLanguage() {
        return this.language;
    }

    @Generated
    public String getSource() {
        return this.source;
    }
}

