/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.External;
import ch.usi.si.seart.treesitter.Node;
import ch.usi.si.seart.treesitter.Tree;
import ch.usi.si.seart.treesitter.TreeCursorNode;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class TreeCursor
extends External
implements Cloneable {
    private final int context0;
    private final int context1;
    private final long id;
    private final Tree tree;

    protected TreeCursor() {
        this.context0 = 0;
        this.context1 = 0;
        this.id = 0L;
        this.tree = null;
    }

    TreeCursor(long pointer, int context0, int context1, long id, @NotNull Tree tree) {
        super(pointer);
        this.context0 = context0;
        this.context1 = context1;
        this.id = id;
        this.tree = tree;
    }

    @Override
    public native void close();

    public native Node getCurrentNode();

    public native String getCurrentFieldName();

    public native TreeCursorNode getCurrentTreeCursorNode();

    public native boolean gotoFirstChild();

    public native boolean gotoNextSibling();

    public native boolean gotoParent();

    public void preorderTraversal(@NotNull Consumer<Node> callback) {
        Objects.requireNonNull(callback, "Callback must not be null!");
        while (true) {
            callback.accept(this.getCurrentNode());
            if (this.gotoFirstChild() || this.gotoNextSibling()) continue;
            do {
                if (this.gotoParent()) continue;
                return;
            } while (!this.gotoNextSibling());
        }
    }

    @Generated
    public String toString() {
        return String.format("TreeCursor(id: %d, tree: %d)", this.id, this.tree.pointer);
    }

    public native TreeCursor clone();
}

