/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.External;
import ch.usi.si.seart.treesitter.Language;
import ch.usi.si.seart.treesitter.Tree;
import ch.usi.si.seart.treesitter.exception.parser.IncompatibleLanguageException;
import ch.usi.si.seart.treesitter.exception.parser.ParsingException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Parser
extends External {
    private final Language language;
    private static final Charset CHARSET = StandardCharsets.UTF_16LE;

    Parser(long pointer, @NotNull Language language) {
        super(pointer);
        this.language = language;
    }

    @Deprecated(since="1.7.0", forRemoval=true)
    public Parser(@NotNull Language language) {
        throw new UnsupportedOperationException("This constructor should no longer be used");
    }

    public static Parser getFor(@NotNull Language language) {
        return Parser.builder().language(language).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static native int getLanguageVersion();

    public static native int getMinimumCompatibleLanguageVersion();

    @Override
    protected native void delete();

    public void setLanguage(@NotNull Language language) {
        Language.validate(language);
        Parser.setLanguage(this, language);
    }

    private static native void setLanguage(Parser var0, Language var1) throws IncompatibleLanguageException;

    public native long getTimeout();

    public void setTimeout(@NotNull Duration duration) {
        Objects.requireNonNull(duration, "Duration must not be null!");
        long micros = duration.toMillis() * TimeUnit.MILLISECONDS.toMicros(1L);
        this.setTimeout(micros);
    }

    public void setTimeout(long timeout, @NotNull TimeUnit timeUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout can not be negative!");
        }
        Objects.requireNonNull(timeUnit, "Time unit must not be null!");
        long micros = timeUnit.toMicros(timeout);
        this.setTimeout(micros);
    }

    public native void setTimeout(long var1);

    public Tree parse(@NotNull String source) throws ParsingException {
        byte[] bytes = source.getBytes(CHARSET);
        return this.parse(source, bytes, bytes.length, null);
    }

    public Tree parse(@NotNull String source, @NotNull Tree oldTree) throws ParsingException {
        byte[] bytes = source.getBytes(CHARSET);
        return this.parse(source, bytes, bytes.length, oldTree);
    }

    public Tree parse(@NotNull Path path) throws ParsingException {
        try {
            String source = Files.readString(path);
            return this.parse(source);
        }
        catch (IOException ex) {
            throw new ParsingException(ex);
        }
    }

    public Tree parse(@NotNull Path path, @NotNull Tree oldTree) throws ParsingException {
        try {
            String source = Files.readString(path);
            return this.parse(source, oldTree);
        }
        catch (IOException ex) {
            throw new ParsingException(ex);
        }
    }

    private native Tree parse(String var1, byte[] var2, int var3, Tree var4);

    @Generated
    public String toString() {
        return String.format("Parser(id: %d, language: %s)", new Object[]{this.pointer, this.language});
    }

    @Generated
    public Language getLanguage() {
        return this.language;
    }

    public static class Builder {
        private Language language = null;

        public Builder language(@NotNull Language language) {
            Language.validate(language);
            this.language = language;
            return this;
        }

        public Parser build() {
            Objects.requireNonNull(this.language, "Language must not be null!");
            return Builder.build(this.language);
        }

        private static native Parser build(Language var0);

        @Generated
        private Builder() {
        }
    }
}

