/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.External;
import ch.usi.si.seart.treesitter.Node;
import ch.usi.si.seart.treesitter.Query;
import ch.usi.si.seart.treesitter.QueryMatch;
import java.util.Iterator;
import java.util.NoSuchElementException;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class QueryCursor
extends External
implements Iterable<QueryMatch> {
    private final Node node;
    private final Query query;
    private boolean executed = false;

    QueryCursor(long pointer, @NotNull Node node, @NotNull Query query) {
        super(pointer);
        this.node = node;
        this.query = query;
    }

    @Deprecated(since="1.5.0", forRemoval=true)
    public QueryCursor(@NotNull Node node, @NotNull Query query) {
        throw new UnsupportedOperationException("This constructor should no longer be used");
    }

    @Override
    protected native void delete();

    public native void execute();

    public native QueryMatch nextMatch();

    @Override
    @NotNull
    public Iterator<QueryMatch> iterator() {
        this.execute();
        return new Iterator<QueryMatch>(){
            private QueryMatch current;
            {
                this.current = QueryCursor.this.nextMatch();
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public QueryMatch next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                QueryMatch match = this.current;
                this.current = QueryCursor.this.nextMatch();
                return match;
            }
        };
    }

    @Generated
    public String toString() {
        return String.format("QueryCursor(node: %s, query: %s)", this.node, this.query);
    }

    @Generated
    public boolean isExecuted() {
        return this.executed;
    }
}

