/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.Capture;
import ch.usi.si.seart.treesitter.Node;
import ch.usi.si.seart.treesitter.Pattern;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.collections4.multimap.UnmodifiableMultiValuedMap;
import org.jetbrains.annotations.NotNull;

public class QueryMatch {
    private final int id;
    private final Pattern pattern;
    private final MultiValuedMap<Capture, Node> captures;

    QueryMatch(int id, @NotNull Pattern pattern, @NotNull Map.Entry<Capture, Node>[] captures) {
        this.id = id;
        this.pattern = pattern;
        this.captures = UnmodifiableMultiValuedMap.unmodifiableMultiValuedMap((MultiValuedMap)((MultiValuedMap)Stream.of(captures).collect(ArrayListValuedHashMap::new, (map, entry) -> map.put((Object)((Capture)entry.getKey()), (Object)((Node)entry.getValue())), MultiValuedMap::putAll)));
    }

    public Map<Capture, Collection<Node>> getCaptures() {
        return this.captures.asMap();
    }

    public Collection<Node> getNodes() {
        return this.captures.values();
    }

    public Collection<Node> getNodes(Capture capture) {
        return this.captures.get((Object)capture);
    }

    public Collection<Node> getNodes(String name) {
        return this.captures.entries().stream().filter(entry -> {
            Capture capture = (Capture)entry.getKey();
            return name.equals(capture.getName());
        }).map(Map.Entry::getValue).collect(Collectors.toUnmodifiableList());
    }

    @Deprecated(since="1.7.0", forRemoval=true)
    @Generated
    public int getPatternIndex() {
        return this.getPattern().getIndex();
    }

    @Generated
    public String toString() {
        String joined = this.captures.entries().stream().map(entry -> entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(", ", "{", "}"));
        return String.format("QueryMatch(id: %d, pattern: '%s', captures: [%s])", this.id, this.pattern, joined);
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }
}

