/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.Parser;
import ch.usi.si.seart.treesitter.Symbol;
import ch.usi.si.seart.treesitter.error.ABIVersionError;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public enum Language {
    _INVALID_,
    ADA(Language.ada(), "adb", "ads"),
    BASH(Language.bash(), "sh", "bash"),
    C(Language.c(), "c", "h"),
    CLOJURE(Language.clojure(), "bb", "clj", "cljc", "cljs"),
    CMAKE(Language.cMake(), "cmake"),
    COMMON_LISP(Language.commonLisp(), "lisp"),
    CSHARP(Language.cSharp(), "cs"),
    CPP(Language.cpp(), "cc", "cpp", "cxx", "hpp", "hxx", "h"),
    CSS(Language.css(), "css"),
    DART(Language.dart(), "dart"),
    DOT(Language.dot(), "dot", "gv"),
    ELIXIR(Language.elixir(), "ex", "exs"),
    ELM(Language.elm(), "elm"),
    EMBEDDED_TEMPLATE(Language.embeddedTemplate(), "ejs", "erb"),
    ERLANG(Language.erlang(), "erl", "hrl"),
    FORTRAN(Language.fortran(), "f", "F90", "f77", "f90", "f95"),
    GO(Language.go(), "go"),
    GRAPHQL(Language.graphQl(), "graphql"),
    HASKELL(Language.haskell(), "hs"),
    HTML(Language.html(), "html"),
    JAVA(Language.java(), "java"),
    JAVASCRIPT(Language.javascript(), "js"),
    JSON(Language.json(), "json"),
    JULIA(Language.julia(), "jl"),
    KOTLIN(Language.kotlin(), "kt", "kts"),
    LATEX(Language.latex(), "tex", "sty", "cls", "aux"),
    LUA(Language.lua(), "lua"),
    MARKDOWN(Language.markdown(), "md"),
    NIX(Language.nix(), "nix"),
    OBJECTIVE_C(Language.objectiveC(), "h", "m"),
    OCAML(Language.ocaml(), "ml", "mli"),
    PASCAL(Language.pascal(), "pas", "pp", "lpr"),
    PHP(Language.php(), "php"),
    PYTHON(Language.python(), "py"),
    R(Language.r(), "R", "r"),
    RACKET(Language.racket(), "rkt"),
    RUBY(Language.ruby(), "rb"),
    RUST(Language.rust(), "rs"),
    SCALA(Language.scala(), "scala", "sbt"),
    SCHEME(Language.scheme(), "scm", "ss"),
    SCSS(Language.scss(), "scss"),
    SVELTE(Language.svelte(), "svelte"),
    SWIFT(Language.swift(), "swift"),
    TOML(Language.toml(), "toml"),
    TSX(Language.tsx(), "tsx"),
    TYPESCRIPT(Language.typescript(), "ts"),
    YAML(Language.yaml(), "yaml", "yml");

    private final long id;
    private final int version;
    private final int totalFields;
    private final Collection<Symbol> symbols;
    private final List<String> extensions;
    private static final long INVALID = 0L;
    private static final Map<String, List<Language>> EXTENSION_LOOKUP;

    private static native long ada();

    private static native long bash();

    private static native long c();

    private static native long clojure();

    private static native long commonLisp();

    private static native long cMake();

    private static native long cSharp();

    private static native long cpp();

    private static native long css();

    private static native long dart();

    private static native long dot();

    private static native long elixir();

    private static native long elm();

    private static native long embeddedTemplate();

    private static native long erlang();

    private static native long fortran();

    private static native long go();

    private static native long graphQl();

    private static native long haskell();

    private static native long html();

    private static native long java();

    private static native long javascript();

    private static native long json();

    private static native long julia();

    private static native long kotlin();

    private static native long latex();

    private static native long lua();

    private static native long markdown();

    private static native long nix();

    private static native long objectiveC();

    private static native long ocaml();

    private static native long pascal();

    private static native long php();

    private static native long python();

    private static native long ruby();

    private static native long r();

    private static native long racket();

    private static native long rust();

    private static native long scala();

    private static native long scheme();

    private static native long scss();

    private static native long svelte();

    private static native long swift();

    private static native long toml();

    private static native long tsx();

    private static native long typescript();

    private static native long yaml();

    public static void validate(@NotNull Language language) {
        Objects.requireNonNull(language, "Language must not be null!");
        long id = language.getId();
        if (id == 0L) {
            throw new UnsatisfiedLinkError("Language binding has not been defined for: " + language);
        }
        int version = language.getVersion();
        int minimum = Parser.getMinimumCompatibleLanguageVersion();
        int maximum = Parser.getLanguageVersion();
        if (version < minimum || version > maximum) {
            throw new ABIVersionError(version);
        }
    }

    @NotNull
    public static Collection<Language> associatedWith(@NotNull Path path) {
        Objects.requireNonNull(path, "Path argument must not be null!");
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path argument must not be a directory!");
        }
        String name = path.getFileName().toString();
        int i = name.lastIndexOf(46);
        return Optional.ofNullable(i > 0 ? name.substring(i + 1) : null).map(EXTENSION_LOOKUP::get).orElseGet(Collections::emptyList);
    }

    private static native int version(long var0);

    private static native int symbols(long var0);

    private static native Symbol symbol(long var0, int var2);

    private static native int fields(long var0);

    private Language() {
        this(0L);
    }

    private Language(long id) {
        this(id, 0, 0, 0, Collections.emptyList());
    }

    private Language(long id, String ... extensions) {
        this(id, Language.version(id), Language.fields(id), Language.symbols(id), List.of(extensions));
    }

    private Language(long id, int version, int totalFields, int totalSymbols, List<String> extensions) {
        this.id = id;
        this.version = version;
        this.totalFields = totalFields;
        this.symbols = IntStream.range(0, totalSymbols).mapToObj(symbolId -> Language.symbol(id, symbolId)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        this.extensions = extensions;
    }

    @Generated
    public int getTotalSymbols() {
        return this.symbols.size();
    }

    public String toString() {
        switch (this) {
            case C: 
            case CSS: 
            case DOT: 
            case HTML: 
            case JSON: 
            case PHP: 
            case R: 
            case SCSS: 
            case TOML: 
            case TSX: 
            case YAML: {
                return this.name();
            }
            case ADA: 
            case BASH: 
            case CLOJURE: 
            case DART: 
            case ELIXIR: 
            case ELM: 
            case ERLANG: 
            case FORTRAN: 
            case GO: 
            case HASKELL: 
            case JAVA: 
            case JULIA: 
            case KOTLIN: 
            case LUA: 
            case MARKDOWN: 
            case NIX: 
            case PASCAL: 
            case PYTHON: 
            case RACKET: 
            case RUBY: 
            case RUST: 
            case SCALA: 
            case SCHEME: 
            case SVELTE: 
            case SWIFT: {
                return Language.capitalize(this.name());
            }
            case COMMON_LISP: 
            case EMBEDDED_TEMPLATE: {
                String[] parts = this.name().split("_");
                return Stream.of(parts).map(Language::capitalize).collect(Collectors.joining(" "));
            }
            case CMAKE: {
                return "CMake";
            }
            case CSHARP: {
                return "C#";
            }
            case CPP: {
                return "C++";
            }
            case GRAPHQL: {
                return "GraphQL";
            }
            case JAVASCRIPT: {
                return "JavaScript";
            }
            case LATEX: {
                return "LaTeX";
            }
            case OBJECTIVE_C: {
                return "Objective-C";
            }
            case OCAML: {
                return "OCaml";
            }
            case TYPESCRIPT: {
                return "TypeScript";
            }
        }
        return "???";
    }

    private static String capitalize(String name) {
        return name.charAt(0) + name.substring(1).toLowerCase();
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public int getVersion() {
        return this.version;
    }

    @Generated
    public int getTotalFields() {
        return this.totalFields;
    }

    @Generated
    public Collection<Symbol> getSymbols() {
        return this.symbols;
    }

    @Generated
    public List<String> getExtensions() {
        return this.extensions;
    }

    static {
        EXTENSION_LOOKUP = Stream.of(Language.values()).flatMap(language -> language.getExtensions().stream().map(extension -> Map.entry(extension, language))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toUnmodifiableList())));
    }
}

