/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.Point;
import ch.usi.si.seart.treesitter.Query;
import ch.usi.si.seart.treesitter.QueryCursor;
import ch.usi.si.seart.treesitter.Range;
import ch.usi.si.seart.treesitter.Symbol;
import ch.usi.si.seart.treesitter.Tree;
import ch.usi.si.seart.treesitter.TreeCursor;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Node
implements Iterable<Node> {
    private final int context0;
    private final int context1;
    private final int context2;
    private final int context3;
    private final long id;
    private final Tree tree;

    Node() {
        this(0, 0, 0, 0, 0L, null);
    }

    public native Node getChild(int var1);

    public native Node getChildByFieldName(@NotNull String var1);

    public native int getChildCount();

    public List<Node> getChildren() {
        Node[] children = Node.getChildren(this);
        return List.of(children);
    }

    private static native Node[] getChildren(Node var0);

    public String getContent() {
        return !this.isNull() ? this.tree.getSource(this.getStartByte(), this.getEndByte()) : null;
    }

    @Deprecated(since="1.6.0", forRemoval=true)
    public Node getDescendantForByteRange(int startByte, int endByte) {
        return this.getDescendant(startByte, endByte);
    }

    public Node getDescendant(int startByte, int endByte) {
        return this.getDescendant(startByte, endByte, false);
    }

    private native Node getDescendant(int var1, int var2, boolean var3);

    public Node getDescendant(@NotNull Point startPoint, @NotNull Point endPoint) {
        return this.getDescendant(startPoint, endPoint, false);
    }

    private native Node getDescendant(Point var1, Point var2, boolean var3);

    public native int getEndByte();

    public native Point getEndPoint();

    public native String getFieldNameForChild(int var1);

    public Node getFirstChildForByte(int offset) {
        return this.getFirstChildForByte(offset, false);
    }

    private native Node getFirstChildForByte(int var1, boolean var2);

    public Node getFirstNamedChildForByte(int offset) {
        return this.getFirstChildForByte(offset, true);
    }

    public Node getNamedDescendant(int startByte, int endByte) {
        return this.getDescendant(startByte, endByte, true);
    }

    public Node getNamedDescendant(@NotNull Point startPoint, @NotNull Point endPoint) {
        return this.getDescendant(startPoint, endPoint, true);
    }

    public native Node getNextNamedSibling();

    public native Node getNextSibling();

    public native Node getPrevNamedSibling();

    public native Node getPrevSibling();

    public native Node getParent();

    public Range getRange() {
        return new Range(this);
    }

    public native int getStartByte();

    public native Point getStartPoint();

    public native Symbol getSymbol();

    public native String getType();

    public native boolean hasError();

    public native boolean isExtra();

    public native boolean isMissing();

    public native boolean isNamed();

    public native boolean isNull();

    public native TreeCursor walk();

    public native QueryCursor walk(@NotNull Query var1);

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return Node.equals(this, other);
    }

    private static native boolean equals(@NotNull Node var0, @NotNull Node var1);

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    @Generated
    public String toString() {
        return String.format("Node(id: %d, tree: %s)", this.id, this.tree);
    }

    @Override
    @NotNull
    public Iterator<Node> iterator() {
        return new Iterator<Node>(){
            private final Deque<Node> stack;
            {
                this.stack = new ArrayDeque<Node>(Collections.singletonList(Node.this));
            }

            @Override
            public boolean hasNext() {
                return !this.stack.isEmpty();
            }

            @Override
            public Node next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Node node = this.stack.pop();
                this.stack.addAll(node.getChildren());
                return node;
            }
        };
    }

    @Generated
    Node(int context0, int context1, int context2, int context3, long id, Tree tree) {
        this.context0 = context0;
        this.context1 = context1;
        this.context2 = context2;
        this.context3 = context3;
        this.id = id;
        this.tree = tree;
    }
}

