/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import ch.usi.si.seart.treesitter.Node;
import ch.usi.si.seart.treesitter.Point;
import ch.usi.si.seart.treesitter.Query;
import ch.usi.si.seart.treesitter.QueryCursor;
import ch.usi.si.seart.treesitter.Range;
import ch.usi.si.seart.treesitter.Symbol;
import ch.usi.si.seart.treesitter.TreeCursor;
import ch.usi.si.seart.treesitter.TreeCursorNode;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class OffsetTreeCursor
extends TreeCursor {
    private static final String UOE_MESSAGE_1 = "Byte positions not available after node position has changed!";
    private static final String UOE_MESSAGE_2 = "Byte position searches not supported after node position has changed!";
    private static final String UOE_MESSAGE_3 = "Querying not available after node position has changed!";
    private static final String UOE_MESSAGE_4 = "Byte positions not available!";
    private final TreeCursor cursor;
    private final Point offset;

    public OffsetTreeCursor(@NotNull Node node, @NotNull Point offset) {
        Objects.requireNonNull(node, "Node must not be null!");
        Objects.requireNonNull(offset, "Offset must not be null!");
        this.cursor = node.walk();
        this.offset = offset;
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public String getCurrentFieldName() {
        return this.cursor.getCurrentFieldName();
    }

    @Override
    public boolean gotoFirstChild() {
        return this.cursor.gotoFirstChild();
    }

    @Override
    public boolean gotoFirstChild(int offset) {
        throw new UnsupportedOperationException(UOE_MESSAGE_2);
    }

    @Override
    public boolean gotoFirstChild(@NotNull Point point) {
        return this.cursor.gotoFirstChild(point.subtract(this.offset));
    }

    @Override
    public boolean gotoNextSibling() {
        return this.cursor.gotoNextSibling();
    }

    @Override
    public boolean gotoParent() {
        return this.cursor.gotoParent();
    }

    @Override
    public void preorderTraversal(@NotNull Consumer<Node> callback) {
        this.cursor.preorderTraversal(callback);
    }

    @Override
    public Node getCurrentNode() {
        return new OffsetNode(this.cursor.getCurrentNode());
    }

    public String toString() {
        return String.format("OffsetTreeCursor(row: %d, column: %d)", this.offset.getRow(), this.offset.getColumn());
    }

    @Override
    public TreeCursorNode getCurrentTreeCursorNode() {
        return new OffsetTreeCursorNode(this.cursor.getCurrentTreeCursorNode(), this.offset);
    }

    private static class PositionOnlyRange
    extends Range {
        PositionOnlyRange(Node node) {
            super(Integer.MIN_VALUE, Integer.MAX_VALUE, node.getStartPoint(), node.getEndPoint());
        }

        @Override
        public int getEndByte() {
            throw new UnsupportedOperationException(OffsetTreeCursor.UOE_MESSAGE_4);
        }

        @Override
        public int getStartByte() {
            throw new UnsupportedOperationException(OffsetTreeCursor.UOE_MESSAGE_4);
        }
    }

    private static class OffsetTreeCursorNode
    extends TreeCursorNode {
        OffsetTreeCursorNode(TreeCursorNode cursorNode, Point offset) {
            this(cursorNode.getName(), cursorNode.getType(), cursorNode.getContent(), cursorNode.getStartPoint().add(offset), cursorNode.getEndPoint().add(offset), cursorNode.isNamed());
        }

        OffsetTreeCursorNode(String name, String type, String content, Point startPoint, Point endPoint, boolean isNamed) {
            super(name, type, content, Integer.MIN_VALUE, Integer.MAX_VALUE, startPoint, endPoint, isNamed);
        }

        @Override
        public int getEndByte() {
            throw new UnsupportedOperationException(OffsetTreeCursor.UOE_MESSAGE_1);
        }

        @Override
        public int getStartByte() {
            throw new UnsupportedOperationException(OffsetTreeCursor.UOE_MESSAGE_1);
        }
    }

    private class OffsetNode
    extends Node {
        private final Node node;

        @Override
        public Node getChild(int child) {
            return new OffsetNode(this.node.getChild(child));
        }

        @Override
        public Node getChildByFieldName(@NotNull String name) {
            return new OffsetNode(this.node.getChildByFieldName(name));
        }

        @Override
        public int getChildCount() {
            return this.node.getChildCount();
        }

        @Override
        public List<Node> getChildren() {
            return this.node.getChildren().stream().map(x$0 -> new OffsetNode((Node)x$0)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }

        @Override
        public String getContent() {
            return this.node.getContent();
        }

        @Override
        public Node getDescendant(int startByte, int endByte) {
            throw new UnsupportedOperationException(OffsetTreeCursor.UOE_MESSAGE_2);
        }

        @Override
        public Node getDescendant(@NotNull Point startPoint, @NotNull Point endPoint) {
            return this.node.getDescendant(startPoint.subtract(OffsetTreeCursor.this.offset), endPoint.subtract(OffsetTreeCursor.this.offset));
        }

        @Override
        public int getEndByte() {
            throw new UnsupportedOperationException(OffsetTreeCursor.UOE_MESSAGE_1);
        }

        @Override
        public Point getEndPoint() {
            return this.node.getEndPoint().add(OffsetTreeCursor.this.offset);
        }

        @Override
        public String getFieldNameForChild(int child) {
            return this.node.getFieldNameForChild(child);
        }

        @Override
        public Node getFirstChildForByte(int offset) {
            throw new UnsupportedOperationException(OffsetTreeCursor.UOE_MESSAGE_2);
        }

        @Override
        public Node getFirstNamedChildForByte(int offset) {
            throw new UnsupportedOperationException(OffsetTreeCursor.UOE_MESSAGE_2);
        }

        @Override
        public Node getNamedDescendant(int startByte, int endByte) {
            throw new UnsupportedOperationException(OffsetTreeCursor.UOE_MESSAGE_2);
        }

        @Override
        public Node getNamedDescendant(@NotNull Point startPoint, @NotNull Point endPoint) {
            return this.node.getNamedDescendant(startPoint.subtract(OffsetTreeCursor.this.offset), endPoint.subtract(OffsetTreeCursor.this.offset));
        }

        @Override
        public Node getNextNamedSibling() {
            return new OffsetNode(this.node.getNextNamedSibling());
        }

        @Override
        public Node getNextSibling() {
            return new OffsetNode(this.node.getNextSibling());
        }

        @Override
        public Node getPrevNamedSibling() {
            return new OffsetNode(this.node.getPrevNamedSibling());
        }

        @Override
        public Node getPrevSibling() {
            return new OffsetNode(this.node.getPrevSibling());
        }

        @Override
        public Node getParent() {
            return new OffsetNode(this.node.getParent());
        }

        @Override
        public Range getRange() {
            return new PositionOnlyRange(this);
        }

        @Override
        public int getStartByte() {
            throw new UnsupportedOperationException(OffsetTreeCursor.UOE_MESSAGE_1);
        }

        @Override
        public Point getStartPoint() {
            return this.node.getStartPoint().add(OffsetTreeCursor.this.offset);
        }

        @Override
        public Symbol getSymbol() {
            return this.node.getSymbol();
        }

        @Override
        public String getType() {
            return this.node.getType();
        }

        @Override
        public boolean hasError() {
            return this.node.hasError();
        }

        @Override
        public boolean isExtra() {
            return this.node.isExtra();
        }

        @Override
        public boolean isMissing() {
            return this.node.isMissing();
        }

        @Override
        public boolean isNamed() {
            return this.node.isNamed();
        }

        @Override
        public boolean isNull() {
            return this.node.isNull();
        }

        @Override
        public TreeCursor walk() {
            return new OffsetTreeCursor(this.node, OffsetTreeCursor.this.offset);
        }

        @Override
        public QueryCursor walk(@NotNull Query query) {
            throw new UnsupportedOperationException(OffsetTreeCursor.UOE_MESSAGE_3);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            OffsetNode other = (OffsetNode)obj;
            return this.node.equals(other.node);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.node, OffsetTreeCursor.this.offset);
        }

        @Override
        public String toString() {
            String original = this.node.toString();
            int lower = Node.class.getSimpleName().length() + 1;
            int upper = original.length() - 1;
            String data = original.substring(lower, upper);
            return String.format("OffsetNode(%s, row: %d, column: %d)", data, OffsetTreeCursor.this.offset.getRow(), OffsetTreeCursor.this.offset.getColumn());
        }

        @Generated
        OffsetNode(Node node) {
            this.node = node;
        }
    }
}

