/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Point
implements Comparable<Point> {
    private static final AtomicReference<Object> ORIGIN = new AtomicReference();
    private final int row;
    private final int column;

    @Generated
    public String toString() {
        return this.row + ":" + this.column;
    }

    public boolean isOrigin() {
        return this.equals(Point.ORIGIN());
    }

    @Override
    public native int compareTo(@NotNull Point var1);

    public Point add(@NotNull Point other) {
        Objects.requireNonNull(other, "Other point must not be null!");
        if (this.isOrigin()) {
            return other;
        }
        if (other.isOrigin()) {
            return this;
        }
        if (this.equals(other)) {
            return this.multiply(2);
        }
        return new Point(this.row + other.row, this.column + other.column);
    }

    public Point subtract(@NotNull Point other) {
        Objects.requireNonNull(other, "Other point must not be null!");
        if (this.isOrigin()) {
            return other.multiply(-1);
        }
        if (other.isOrigin()) {
            return this;
        }
        if (this.equals(other)) {
            return Point.ORIGIN();
        }
        return new Point(this.row - other.row, this.column - other.column);
    }

    public Point multiply(int value) {
        if (value == 0) {
            return Point.ORIGIN();
        }
        if (value == 1) {
            return this;
        }
        return new Point(this.row * value, this.column * value);
    }

    @Generated
    public int getRow() {
        return this.row;
    }

    @Generated
    public int getColumn() {
        return this.column;
    }

    @Generated
    public Point(int row, int column) {
        this.row = row;
        this.column = column;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRow() != other.getRow()) {
            return false;
        }
        return this.getColumn() == other.getColumn();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Point;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRow();
        result = result * 59 + this.getColumn();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static Point ORIGIN() {
        Object value = ORIGIN.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = ORIGIN;
            synchronized (atomicReference) {
                value = ORIGIN.get();
                if (value == null) {
                    Point actualValue = new Point(0, 0);
                    value = actualValue == null ? ORIGIN : actualValue;
                    ORIGIN.set(value);
                }
            }
        }
        return (Point)(value == ORIGIN ? null : value);
    }
}

