/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.treesitter.printer;

import ch.usi.si.seart.treesitter.Point;
import ch.usi.si.seart.treesitter.TreeCursor;
import ch.usi.si.seart.treesitter.TreeCursorNode;
import ch.usi.si.seart.treesitter.printer.IterativeTreePrinter;
import java.util.ArrayDeque;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class XMLPrinter
extends IterativeTreePrinter {
    public static final String PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public XMLPrinter(@NotNull TreeCursor cursor) {
        super(cursor);
    }

    @Override
    protected String getPreamble() {
        return PROLOG;
    }

    @Override
    protected String getFileExtension() {
        return ".xml";
    }

    @Override
    protected void write(Consumer<String> appender) {
        boolean visitedChildren = false;
        ArrayDeque<String> tags = new ArrayDeque<String>();
        while (true) {
            TreeCursorNode cursorNode = this.cursor.getCurrentTreeCursorNode();
            boolean isNamed = cursorNode.isNamed();
            String type = cursorNode.getType();
            String name = cursorNode.getName();
            Point start = cursorNode.getStartPoint();
            Point end = cursorNode.getEndPoint();
            if (visitedChildren) {
                if (isNamed) {
                    appender.accept("</");
                    appender.accept((String)tags.pop());
                    appender.accept(">");
                }
                if (this.cursor.gotoNextSibling()) {
                    visitedChildren = false;
                    continue;
                }
                if (this.cursor.gotoParent()) {
                    visitedChildren = true;
                    continue;
                }
                return;
            }
            if (isNamed) {
                appender.accept("<");
                appender.accept(type);
                appender.accept(" ");
                if (name != null) {
                    appender.accept("name=\"");
                    appender.accept(name);
                    appender.accept("\" ");
                }
                appender.accept("start=\"");
                appender.accept(start.toString());
                appender.accept("\" ");
                appender.accept("end=\"");
                appender.accept(end.toString());
                appender.accept("\">");
                tags.push(type);
            }
            visitedChildren = !this.cursor.gotoFirstChild();
        }
    }
}

