/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.cloc;

import ch.usi.si.seart.cloc.CLOCException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CLOC {
    private static final String CMD = "cloc";
    private static final String TMPDIR_PATH = System.getProperty("java.io.tmpdir");
    private static final String EXECUTABLE = CLOC.getBundledExecutable();
    private static final JsonMapper DEFAULT_MAPPER;
    private static volatile JsonMapper OUTPUT_MAPPER;
    private final CommandLine commandLine;
    private final int timeout;

    private CLOC(CommandLine commandLine, int timeout) {
        this.commandLine = commandLine;
        this.timeout = timeout;
    }

    public static void setOutputMapper(@Nullable JsonMapper mapper) {
        OUTPUT_MAPPER = mapper == null ? DEFAULT_MAPPER : mapper;
    }

    public static Builder command() {
        return new Builder();
    }

    private static String getBundledExecutable() {
        String protocol;
        URL url = CLOC.class.getClassLoader().getResource(CMD);
        switch (protocol = Objects.requireNonNull(url).getProtocol()) {
            case "file": {
                return url.getPath();
            }
            case "jar": {
                try {
                    File tmpdir = new File(TMPDIR_PATH);
                    File script = new File(tmpdir, CMD);
                    FileUtils.copyURLToFile((URL)url, (File)script);
                    boolean ignore = script.setExecutable(true);
                    script.deleteOnExit();
                    return script.getAbsolutePath();
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported protocol: " + protocol);
    }

    public ObjectNode linesByLanguage() throws CLOCException {
        return CLOC.execute(this.commandLine.clone(), this.timeout);
    }

    public ObjectNode linesByFile() throws CLOCException {
        return CLOC.execute(this.commandLine.withArgument("--by-file"), this.timeout);
    }

    public ObjectNode linesByFileAndLanguage() throws CLOCException {
        return CLOC.execute(this.commandLine.withArgument("--by-file-by-lang"), this.timeout);
    }

    public ObjectNode countFiles() throws CLOCException {
        return CLOC.execute(this.commandLine.withArgument("--only-count-files"), this.timeout);
    }

    private static ObjectNode execute(Commandline commandline, int timeout) throws CLOCException {
        try {
            StringStreamConsumer out = new StringStreamConsumer();
            StringStreamConsumer err = new StringStreamConsumer();
            int code = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)out, (StreamConsumer)err, (int)timeout);
            if (code != 0) {
                throw new CLOCException(err.getOutput());
            }
            JsonNode json = OUTPUT_MAPPER.readTree(out.getOutput());
            return (ObjectNode)OUTPUT_MAPPER.convertValue((Object)json, ObjectNode.class);
        }
        catch (JsonProcessingException ex) {
            throw new CLOCException(ex);
        }
        catch (CommandLineException ex) {
            throw new CLOCException(ex.getMessage(), ex.getCause());
        }
        catch (IllegalArgumentException ex) {
            throw new CLOCException("Unexpected output format!", ex);
        }
    }

    static {
        OUTPUT_MAPPER = DEFAULT_MAPPER = new JsonMapper();
    }

    private static final class StringStreamConsumer
    extends CommandLineUtils.StringStreamConsumer {
        private StringStreamConsumer() {
        }
    }

    private static final class CommandLine
    extends Commandline {
        private CommandLine() {
        }

        public CommandLine clone() {
            CommandLine clone = new CommandLine();
            clone.setShell(this.getShell());
            clone.setExecutable(this.getLiteralExecutable());
            clone.setWorkingDirectory(this.getWorkingDirectory());
            clone.addArguments(this.getArguments());
            return clone;
        }

        @Contract(value="_ -> new")
        @NotNull
        public CommandLine withArgument(String value) {
            CommandLine clone = this.clone();
            clone.createArg(value);
            return clone;
        }

        public void createArg(String value) {
            this.createArg().setValue(value);
        }
    }

    public static final class Builder {
        private int timeout = 0;
        private final Set<String> flags = Stream.of("json", "quiet").collect(Collectors.toCollection(LinkedHashSet::new));
        private final Map<String, String> parameters = new LinkedHashMap<String, String>();

        @Contract(value="_ -> this")
        public Builder timeout(int value) {
            if (value < 0) {
                throw new IllegalArgumentException("Timeout must be greater than or equal to 0!");
            }
            this.timeout = value;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder cores(int value) {
            if (value < 0) {
                throw new IllegalArgumentException("Number of cores must be greater than or equal to 0!");
            }
            if (value > 1) {
                this.parameters.put("processes", String.valueOf(value));
            } else {
                this.parameters.remove("processes");
            }
            return this;
        }

        @Contract(value="_ -> this")
        public Builder docstringAsCode(boolean value) {
            Consumer<String> action = value ? this.flags::add : this.flags::remove;
            action.accept("docstring-as-code");
            return this;
        }

        @Contract(value="_ -> this")
        public Builder followLinks(boolean value) {
            Consumer<String> action = value ? this.flags::add : this.flags::remove;
            action.accept("follow-links");
            return this;
        }

        @Contract(value="_ -> this")
        public Builder maxFileSize(int value) {
            if (value <= 0) {
                throw new IllegalArgumentException("Maximum file size must be greater than 0!");
            }
            this.parameters.put("max-file-size", String.valueOf(value));
            return this;
        }

        @Contract(value="_ -> this")
        public Builder noRecurse(boolean value) {
            Consumer<String> action = value ? this.flags::add : this.flags::remove;
            action.accept("no-recurse");
            return this;
        }

        @Contract(value="_ -> this")
        public Builder readBinaryFiles(boolean value) {
            Consumer<String> action = value ? this.flags::add : this.flags::remove;
            action.accept("read-binary-files");
            return this;
        }

        @Contract(value="_ -> this")
        public Builder skipUniqueness(boolean value) {
            Consumer<String> action = value ? this.flags::add : this.flags::remove;
            action.accept("skip-uniqueness");
            return this;
        }

        @Contract(value="_ -> new")
        @NotNull
        public CLOC target(@NotNull Path path) {
            Objects.requireNonNull(path, "Path must not be null!");
            File file = path.toFile();
            if (!file.exists()) {
                throw new IllegalArgumentException("Unable to read: " + path);
            }
            CommandLine commandLine = new CommandLine();
            commandLine.setExecutable(EXECUTABLE);
            commandLine.createArg().setFile(file);
            this.flags.stream().map(flag -> "--" + flag).forEach(commandLine::createArg);
            this.parameters.entrySet().stream().map(entry -> "--" + (String)entry.getKey() + "=" + (String)entry.getValue()).forEach(commandLine::createArg);
            return new CLOC(commandLine, this.timeout);
        }
    }
}

