/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.cloc;

import ch.usi.si.seart.cloc.CLOCException;
import ch.usi.si.seart.cloc.MD5;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CLOC {
    private static final JsonMapper DEFAULT_MAPPER;
    private static volatile JsonMapper OUTPUT_MAPPER;
    private final CommandLine commandLine;
    private final int timeout;
    private static volatile Properties PROPERTIES;
    private static volatile File EXECUTABLE;

    private CLOC(CommandLine commandLine, int timeout) {
        this.commandLine = commandLine;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties getProperties() {
        if (PROPERTIES != null) return PROPERTIES;
        Class<CLOC> clazz = CLOC.class;
        synchronized (CLOC.class) {
            if (PROPERTIES != null) return PROPERTIES;
            PROPERTIES = new Properties();
            try (InputStream stream = CLOC.class.getClassLoader().getResourceAsStream("cloc.properties");){
                PROPERTIES.load(stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return PROPERTIES;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static File getExecutable() {
        String protocol;
        if (EXECUTABLE != null) return EXECUTABLE;
        Class<CLOC> clazz = CLOC.class;
        // MONITORENTER : ch.usi.si.seart.cloc.CLOC.class
        if (EXECUTABLE != null) {
            // MONITOREXIT : clazz
            return EXECUTABLE;
        }
        URL url = CLOC.class.getClassLoader().getResource("cloc.pl");
        switch (protocol = Objects.requireNonNull(url).getProtocol()) {
            case "file": {
                String path = url.getPath();
                EXECUTABLE = new File(path);
                return EXECUTABLE;
            }
            case "jar": {
                try {
                    File script = new File(SystemUtils.USER_HOME, "cloc.pl");
                    if (CLOC.getMD5() != null && script.exists() && MD5.hash(script).equals(CLOC.getMD5())) {
                        EXECUTABLE = script;
                        return EXECUTABLE;
                    }
                    FileUtils.copyURLToFile((URL)url, (File)script);
                    boolean success = script.setExecutable(true);
                    if (!success) throw new IOException("Unable change execute permissions: " + script);
                    EXECUTABLE = script;
                    return EXECUTABLE;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported protocol: " + protocol);
    }

    @Nullable
    public static String getURL() {
        return CLOC.getProperties().getProperty("cloc.url");
    }

    @Nullable
    public static String getVersion() {
        return CLOC.getProperties().getProperty("cloc.version");
    }

    @Nullable
    public static String getMD5() {
        return CLOC.getProperties().getProperty("cloc.md5");
    }

    public static void setOutputMapper(@Nullable JsonMapper mapper) {
        OUTPUT_MAPPER = mapper == null ? DEFAULT_MAPPER : mapper;
    }

    public static Builder command() {
        return new Builder();
    }

    public ObjectNode linesByLanguage() throws CLOCException {
        return CLOC.execute(this.commandLine.clone(), this.timeout);
    }

    public ObjectNode linesByFile() throws CLOCException {
        return CLOC.execute(this.commandLine.withArgument("--by-file"), this.timeout);
    }

    public ObjectNode linesByFileAndLanguage() throws CLOCException {
        return CLOC.execute(this.commandLine.withArgument("--by-file-by-lang"), this.timeout);
    }

    public ObjectNode countFiles() throws CLOCException {
        return CLOC.execute(this.commandLine.withArgument("--only-count-files"), this.timeout);
    }

    private static ObjectNode execute(Commandline commandline, int timeout) throws CLOCException {
        try {
            StringStreamConsumer out = new StringStreamConsumer();
            StringStreamConsumer err = new StringStreamConsumer();
            int code = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)out, (StreamConsumer)err, (int)timeout);
            if (code != 0) {
                throw new CLOCException(err.getOutput());
            }
            JsonNode json = OUTPUT_MAPPER.readTree(out.getOutput());
            return (ObjectNode)OUTPUT_MAPPER.convertValue((Object)json, ObjectNode.class);
        }
        catch (JsonProcessingException ex) {
            throw new CLOCException(ex);
        }
        catch (CommandLineException ex) {
            throw new CLOCException(ex.getMessage(), ex.getCause());
        }
        catch (IllegalArgumentException ex) {
            throw new CLOCException("Unexpected output format!", ex);
        }
    }

    static {
        OUTPUT_MAPPER = DEFAULT_MAPPER = new JsonMapper();
    }

    private static final class StringStreamConsumer
    extends CommandLineUtils.StringStreamConsumer {
        private StringStreamConsumer() {
        }
    }

    private static final class CommandLine
    extends Commandline {
        private CommandLine() {
        }

        public CommandLine clone() {
            CommandLine clone = new CommandLine();
            clone.setShell(this.getShell());
            clone.setExecutable(this.getLiteralExecutable());
            clone.setWorkingDirectory(this.getWorkingDirectory());
            clone.addArguments(this.getArguments());
            return clone;
        }

        @Contract(value="_ -> new")
        @NotNull
        public CommandLine withArgument(String value) {
            CommandLine clone = this.clone();
            clone.createArg(value);
            return clone;
        }

        public void createArg(String value) {
            this.createArg().setValue(value);
        }
    }

    public static final class Builder {
        private int timeout = 0;
        private final Set<String> flags = Stream.of("json", "quiet").collect(Collectors.toCollection(LinkedHashSet::new));
        private final Map<String, String> parameters = new LinkedHashMap<String, String>();

        @Contract(value="_ -> this")
        public Builder timeout(int value) {
            if (value < 0) {
                throw new IllegalArgumentException("Timeout must be greater than or equal to 0!");
            }
            this.timeout = value;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder cores(int value) {
            if (value < 0) {
                throw new IllegalArgumentException("Number of cores must be greater than or equal to 0!");
            }
            if (value > 1) {
                this.parameters.put("processes", String.valueOf(value));
            } else {
                this.parameters.remove("processes");
            }
            return this;
        }

        @Contract(value="_ -> this")
        public Builder docstringAsCode(boolean value) {
            Consumer<String> action = value ? this.flags::add : this.flags::remove;
            action.accept("docstring-as-code");
            return this;
        }

        @Contract(value="_ -> this")
        public Builder followLinks(boolean value) {
            Consumer<String> action = value ? this.flags::add : this.flags::remove;
            action.accept("follow-links");
            return this;
        }

        @Contract(value="_ -> this")
        public Builder maxFileSize(int value) {
            if (value <= 0) {
                throw new IllegalArgumentException("Maximum file size must be greater than 0!");
            }
            this.parameters.put("max-file-size", String.valueOf(value));
            return this;
        }

        @Contract(value="_ -> this")
        public Builder noRecurse(boolean value) {
            Consumer<String> action = value ? this.flags::add : this.flags::remove;
            action.accept("no-recurse");
            return this;
        }

        @Contract(value="_ -> this")
        public Builder readBinaryFiles(boolean value) {
            Consumer<String> action = value ? this.flags::add : this.flags::remove;
            action.accept("read-binary-files");
            return this;
        }

        @Contract(value="_ -> this")
        public Builder skipUniqueness(boolean value) {
            Consumer<String> action = value ? this.flags::add : this.flags::remove;
            action.accept("skip-uniqueness");
            return this;
        }

        @Contract(value="_ -> new")
        @NotNull
        public CLOC target(@NotNull Path path) {
            File executable = CLOC.getExecutable();
            File file = Objects.requireNonNull(path, "Path must not be null!").toFile();
            if (!file.exists()) {
                throw new IllegalArgumentException("Unable to read: " + path);
            }
            CommandLine commandLine = new CommandLine();
            commandLine.createArg("perl");
            commandLine.createArg().setFile(executable);
            commandLine.createArg().setFile(file);
            this.flags.stream().map(flag -> "--" + flag).forEach(commandLine::createArg);
            this.parameters.entrySet().stream().map(entry -> "--" + (String)entry.getKey() + "=" + (String)entry.getValue()).forEach(commandLine::createArg);
            return new CLOC(commandLine, this.timeout);
        }
    }
}

