/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.src2abs;

import ch.usi.si.seart.src2abs.Parser;
import ch.usi.si.seart.src2abs.Tokenizer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Abstractor {
    public static void abstractCode(Parser.Granularity granularity, Path input, Path output, Set<String> idioms) {
        String original = Files.readString(input);
        Result result = new Result(granularity, original, idioms);
        Files.write(output, result.getAbstracted().getBytes(), new OpenOption[0]);
        Path mapping = output.resolveSibling(output.getFileName() + ".map");
        String keys = String.join((CharSequence)",", result.mappingKeys());
        String values = String.join((CharSequence)",", result.mappingValues());
        Files.write(mapping, List.of(keys, values), new OpenOption[0]);
    }

    public static void abstractCode(Parser.Granularity granularity, Path input, Set<String> idioms) {
        String original = Files.readString(input);
        Result result = new Result(granularity, original, idioms);
        System.out.print(result);
    }

    public static Result abstractCode(Parser.Granularity granularity, String original, Set<String> idioms) {
        return new Result(granularity, original, idioms);
    }

    private Abstractor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Result {
        private final String abstracted;
        private final Map<String, String> mapping;

        private Result(Parser.Granularity granularity, String original, Set<String> idioms) {
            String cleaned = Result.cleanCode(original);
            Parser parser = new Parser(granularity);
            parser.parse(cleaned);
            Tokenizer tokenizer = new Tokenizer(parser, idioms);
            this.abstracted = tokenizer.tokenize(cleaned);
            this.mapping = tokenizer.export();
        }

        public Collection<String> mappingKeys() {
            return this.mapping.keySet();
        }

        public Collection<String> mappingValues() {
            return this.mapping.values();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.abstracted);
            if (!this.mapping.isEmpty()) {
                builder.append('\n');
                builder.append('\n');
                this.mapping.forEach((key, value) -> builder.append((String)value).append(' ').append('=').append(' ').append((String)key).append('\n'));
            }
            return builder.toString();
        }

        private static String cleanCode(String sourceCode) {
            Pattern pattern = Pattern.compile("(\".+\")");
            Matcher matcher = pattern.matcher(sourceCode);
            while (matcher.find()) {
                for (int i = 0; i <= matcher.groupCount(); ++i) {
                    String group = matcher.group(i);
                    String okGroup = group.replaceAll("//", "<DOUBLE_SLASH>");
                    sourceCode = sourceCode.replace(group, okGroup);
                }
            }
            sourceCode = sourceCode.replaceAll("(?:/\\*(?:[^*]|(?:\\*+[^*/]))*\\*+/)|(?://.*)", "");
            return sourceCode;
        }

        public String getAbstracted() {
            return this.abstracted;
        }

        public Map<String, String> getMapping() {
            return this.mapping;
        }
    }
}

