/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.src2abs;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.type.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

class Parser {
    private final Set<String> types = new HashSet<String>();
    private final Set<String> methods = new HashSet<String>();
    private final Set<String> annotations = new HashSet<String>();
    private final Granularity granularity;

    public void parse(String sourceCode) {
        Function<String, Node> parsingFunction;
        switch (this.granularity) {
            case CLASS: {
                parsingFunction = StaticJavaParser::parse;
                break;
            }
            case METHOD: {
                parsingFunction = StaticJavaParser::parseMethodDeclaration;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Parsing not supported at '" + this.granularity + "'");
            }
        }
        this.parse(sourceCode, parsingFunction);
    }

    public void parse(String sourceCode, Function<String, Node> parsingFunction) {
        Node node = parsingFunction.apply(sourceCode);
        this.traverseNode(node);
    }

    private void traverseNode(Node node) {
        node.findAll(AnnotationExpr.class).stream().map(NodeWithName::getNameAsString).forEach(this.annotations::add);
        node.findAll(Type.class).stream().flatMap(type -> {
            String[] allTypes = this.filterString(type.asString());
            return Stream.of(allTypes);
        }).forEach(this.types::add);
        node.findAll(MethodDeclaration.class).stream().map(NodeWithSimpleName::getNameAsString).forEach(this.methods::add);
        node.findAll(MethodCallExpr.class).stream().map(NodeWithSimpleName::getNameAsString).forEach(this.methods::add);
        node.findAll(MethodCallExpr.class).stream().map(MethodCallExpr::getScope).flatMap(Optional::stream).filter(expression -> expression.isFieldAccessExpr() || expression.isNameExpr()).forEach(expression -> {
            String exprStr = expression.toString();
            String[] fragments = exprStr.split("\\.");
            String[] letters = fragments[fragments.length - 1].split("");
            if (!letters[0].equals(letters[0].toLowerCase())) {
                String[] allTypes = this.filterString(exprStr);
                this.types.addAll(Arrays.asList(allTypes));
            }
        });
        node.findAll(MethodReferenceExpr.class).stream().map(MethodReferenceExpr::getIdentifier).forEach(this.methods::add);
    }

    private String[] filterString(String typeString) {
        typeString = typeString.replaceAll("\\[", " ");
        typeString = typeString.replaceAll("\\]", " ");
        typeString = typeString.replaceAll("\\(", " ");
        typeString = typeString.replaceAll("\\)", " ");
        typeString = typeString.replaceAll(">", " ");
        typeString = typeString.replaceAll("<", " ");
        typeString = typeString.replaceAll("\\{", " ");
        typeString = typeString.replaceAll("\\}", " ");
        typeString = typeString.replaceAll("\\,", " ");
        typeString = typeString.replaceAll("\\?", " ");
        typeString = typeString.replaceAll("extends", " ");
        typeString = typeString.replaceAll("implements", " ");
        String[] listString = typeString.split(" ");
        return listString;
    }

    public Set<String> getTypes() {
        return this.types;
    }

    public Set<String> getMethods() {
        return this.methods;
    }

    public Set<String> getAnnotations() {
        return this.annotations;
    }

    public Granularity getGranularity() {
        return this.granularity;
    }

    public Parser(Granularity granularity) {
        this.granularity = granularity;
    }

    public static enum Granularity {
        METHOD,
        CLASS;

    }
}

