/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.si.seart.src2abs;

import ch.usi.si.seart.src2abs.Lexer;
import ch.usi.si.seart.src2abs.Parser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Token;

class Tokenizer {
    private static final String SPACED_DOT = " . ";
    private final Map<String, String> stringLiterals = new LinkedHashMap<String, String>();
    private final Map<String, String> charLiterals = new LinkedHashMap<String, String>();
    private final Map<String, String> intLiterals = new LinkedHashMap<String, String>();
    private final Map<String, String> floatLiterals = new LinkedHashMap<String, String>();
    private final Map<String, String> typeMap = new LinkedHashMap<String, String>();
    private final Map<String, String> methodMap = new LinkedHashMap<String, String>();
    private final Map<String, String> annotationMap = new LinkedHashMap<String, String>();
    private final Map<String, String> varMap = new LinkedHashMap<String, String>();
    private final Set<String> types;
    private final Set<String> methods;
    private final Set<String> annotations;
    private final Set<String> idioms;
    private final Function<String, String> getTypeId = this._idGetter(this.typeMap, "TYPE_");
    private final Function<String, String> getVarId = this._idGetter(this.varMap, "VAR_");
    private final Function<String, String> getMethodId = this._idGetter(this.methodMap, "METHOD_");
    private final AtomicInteger annotationsCounter = new AtomicInteger();
    private final Function<Token, String> getCharId = this._literalIdGetter(this.charLiterals, "CHAR_");
    private final Function<Token, String> getFloatId = this._literalIdGetter(this.floatLiterals, "FLOAT_");
    private final Function<Token, String> getIntId = this._literalIdGetter(this.intLiterals, "INT_");
    private final Function<Token, String> getStringId = this._literalIdGetter(this.stringLiterals, "STRING_");

    public Tokenizer(Parser parser, Set<String> idioms) {
        this(parser.getTypes(), parser.getMethods(), parser.getAnnotations(), idioms);
    }

    public String tokenize(String sourceCode) {
        List<Token> tokens = Tokenizer.readTokens(sourceCode);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            String token = "";
            Token t = tokens.get(i);
            if (t.getType() == 101) {
                int j = i + 1;
                Token nextToken = tokens.get(j);
                if (nextToken.getType() == 100 && this.annotations.contains(nextToken.getText())) {
                    token = this.getAnnotationID(nextToken.getText());
                    i = j;
                }
            } else if (t.getType() == 100) {
                Object tokenName = t.getText();
                boolean expectDOT = true;
                for (int j = i + 1; j < tokens.size(); ++j) {
                    Token nextToken = tokens.get(j);
                    if (expectDOT) {
                        if (nextToken.getType() == 65) {
                            tokenName = (String)tokenName + nextToken.getText();
                            expectDOT = false;
                            continue;
                        }
                        i = j - 1;
                        break;
                    }
                    if ((nextToken.getType() == 100 || nextToken.getType() == 43 || nextToken.getType() == 9 || nextToken.getType() == 31) && tokens.get(j - 1).getType() == 65) {
                        tokenName = (String)tokenName + nextToken.getText();
                        continue;
                    }
                    i = j - 1;
                    break;
                }
                token = this.analyzeIdentifier((String)tokenName, tokens, i);
            } else {
                token = t.getType() == 54 ? this.getCharId(t) : (t.getType() == 52 ? this.getFloatId(t) : (t.getType() == 51 ? this.getIntId(t) : (t.getType() == 55 ? this.getStringId(t) : t.getText())));
            }
            sb.append(token).append(" ");
        }
        return sb.toString().trim();
    }

    public static List<Token> readTokens(String sourceCode) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(sourceCode.getBytes(StandardCharsets.UTF_8));
        Lexer jLexer = new Lexer((CharStream)new ANTLRInputStream((InputStream)inputStream));
        jLexer.removeErrorListeners();
        ArrayList<Token> tokens = new ArrayList<Token>();
        Token t = jLexer.nextToken();
        while (t.getType() != -1) {
            tokens.add(t);
            t = jLexer.nextToken();
        }
        return tokens;
    }

    public Map<String, String> export() {
        return Stream.of(this.typeMap.entrySet().stream(), this.methodMap.entrySet().stream(), this.varMap.entrySet().stream(), this.annotationMap.entrySet().stream(), this.charLiterals.entrySet().stream(), this.floatLiterals.entrySet().stream(), this.intLiterals.entrySet().stream(), this.stringLiterals.entrySet().stream()).flatMap(Function.identity()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2, LinkedHashMap::new));
    }

    private String analyzeIdentifier(String token, List<Token> tokens, int i) {
        String firstPart;
        String lastPart;
        Token t;
        if (this.idioms.contains(token)) {
            return token;
        }
        String[] tokenParts = token.split("\\.");
        if (tokenParts.length > 1) {
            String lastPart2 = tokenParts[tokenParts.length - 1];
            String firstPart2 = token.substring(0, token.length() - lastPart2.length() - 1);
            if (this.idioms.contains(lastPart2)) {
                if (this.idioms.contains(firstPart2)) {
                    return firstPart2 + SPACED_DOT + lastPart2;
                }
                if (this.types.contains(firstPart2)) {
                    return this.getTypeId(firstPart2) + SPACED_DOT + lastPart2;
                }
                return this.getVarId(firstPart2) + SPACED_DOT + lastPart2;
            }
            if (this.idioms.contains(firstPart2)) {
                if (this.types.contains(lastPart2)) {
                    return firstPart2 + SPACED_DOT + this.getTypeId(lastPart2);
                }
                return firstPart2 + SPACED_DOT + this.getVarId(lastPart2);
            }
        }
        if (this.types.contains(token)) {
            return this.getTypeId(token);
        }
        boolean couldBeMethod = false;
        if (i + 1 < tokens.size() && (t = tokens.get(i + 1)).getType() == 57) {
            couldBeMethod = true;
        }
        if (i > 2) {
            Token t1 = tokens.get(i - 1);
            Token t2 = tokens.get(i - 2);
            if (t1.getType() == 72 && t2.getType() == 72) {
                couldBeMethod = true;
            }
        }
        if (this.methods.contains(token) && couldBeMethod) {
            return this.getMethodId(token);
        }
        if (tokenParts.length > 1) {
            lastPart = tokenParts[tokenParts.length - 1];
            firstPart = token.substring(0, token.length() - lastPart.length() - 1);
            if (this.methods.contains(lastPart) && couldBeMethod) {
                if (this.idioms.contains(firstPart)) {
                    return firstPart + SPACED_DOT + this.getMethodId(lastPart);
                }
                if (this.types.contains(firstPart)) {
                    return this.getTypeId(firstPart) + SPACED_DOT + this.getMethodId(lastPart);
                }
                return this.getVarId(firstPart) + SPACED_DOT + this.getMethodId(lastPart);
            }
        }
        if (tokenParts.length > 1) {
            lastPart = tokenParts[tokenParts.length - 1];
            firstPart = token.substring(0, token.length() - lastPart.length() - 1);
            if (this.varMap.containsKey(lastPart)) {
                if (this.idioms.contains(firstPart)) {
                    return firstPart + SPACED_DOT + this.getVarId(lastPart);
                }
                if (this.types.contains(firstPart)) {
                    return this.getTypeId(firstPart) + SPACED_DOT + this.getVarId(lastPart);
                }
                return this.getVarId(firstPart) + SPACED_DOT + this.getVarId(lastPart);
            }
        }
        if (tokenParts.length > 1) {
            lastPart = tokenParts[tokenParts.length - 1];
            firstPart = token.substring(0, token.length() - lastPart.length() - 1);
            if (this.types.contains(firstPart)) {
                if (this.idioms.contains(lastPart) || lastPart.equals("this") || lastPart.equals("class")) {
                    return this.getTypeId(firstPart) + SPACED_DOT + lastPart;
                }
                return this.getTypeId(firstPart) + SPACED_DOT + this.getVarId(lastPart);
            }
            if (this.varMap.containsKey(firstPart)) {
                if (this.idioms.contains(lastPart)) {
                    return this.getVarId(firstPart) + SPACED_DOT + lastPart;
                }
                if (lastPart.equals("new")) {
                    return this.getVarId(firstPart) + SPACED_DOT + lastPart;
                }
                return this.getVarId(firstPart) + SPACED_DOT + this.getVarId(lastPart);
            }
        }
        if (tokenParts.length > 1) {
            lastPart = tokenParts[tokenParts.length - 1];
            firstPart = token.substring(0, token.length() - lastPart.length() - 1);
            if (lastPart.equals("this") || lastPart.equals("class")) {
                if (this.idioms.contains(firstPart)) {
                    return firstPart + SPACED_DOT + lastPart;
                }
                return this.getVarId(firstPart) + SPACED_DOT + lastPart;
            }
            if (this.idioms.contains(firstPart) && this.idioms.contains(lastPart)) {
                return firstPart + SPACED_DOT + lastPart;
            }
            if (this.idioms.contains(firstPart)) {
                return firstPart + SPACED_DOT + this.getVarId(lastPart);
            }
            if (this.idioms.contains(lastPart)) {
                return this.getVarId(firstPart) + SPACED_DOT + lastPart;
            }
            return this.getVarId(firstPart) + SPACED_DOT + this.getVarId(lastPart);
        }
        return this.getVarId(token);
    }

    private String getTypeId(String token) {
        return this.getTypeId.apply(token);
    }

    private String getVarId(String token) {
        return this.getVarId.apply(token);
    }

    private String getMethodId(String token) {
        return this.getMethodId.apply(token);
    }

    private Function<String, String> _idGetter(Map<String, String> literals, String prefix) {
        AtomicInteger counter = new AtomicInteger();
        return text -> {
            if (literals.containsKey(text)) {
                return (String)literals.get(text);
            }
            String id = prefix + counter.incrementAndGet();
            literals.put((String)text, id);
            return id;
        };
    }

    private String getAnnotationID(String token) {
        if (this.idioms.contains("@" + token)) {
            return "@" + token;
        }
        if (this.annotationMap.containsKey(token)) {
            return this.annotationMap.get(token);
        }
        String id = "ANNOTATION_" + this.annotationsCounter.incrementAndGet();
        this.annotationMap.put(token, id);
        return id;
    }

    private String getCharId(Token token) {
        return this.getCharId.apply(token);
    }

    private String getFloatId(Token token) {
        return this.getFloatId.apply(token);
    }

    private String getIntId(Token token) {
        return this.getIntId.apply(token);
    }

    private String getStringId(Token token) {
        return this.getStringId.apply(token);
    }

    private Function<Token, String> _literalIdGetter(Map<String, String> literals, String prefix) {
        AtomicInteger counter = new AtomicInteger();
        return token -> {
            String text = token.getText();
            if (this.idioms.contains(text)) {
                return text;
            }
            if (literals.containsKey(text)) {
                return (String)literals.get(text);
            }
            String id = prefix + counter.incrementAndGet();
            literals.put(text, id);
            return id;
        };
    }

    private Tokenizer(Set<String> types, Set<String> methods, Set<String> annotations, Set<String> idioms) {
        this.types = types;
        this.methods = methods;
        this.annotations = annotations;
        this.idioms = idioms;
    }
}

