package ch.viseon.openOrca.client

import ch.viseon.openOrca.share.*
import kodando.rxjs.Rx

/**
 * The observer* methods allow a declarative approach to listen to changes.
 *
 */
interface ClientOrca {

  fun observeModelStore(): Rx.IObservable<ModelStoreChangeEvent>
  fun observeModel(modelId: ModelId): Rx.IObservable<PropertyChangeEvent>
  fun observeModel(modelType: ModelType): Rx.IObservable<PropertyChangeEvent>
  fun observeProperty(modelId: ModelId, propertyName: PropertyName): Rx.IObservable<ValueChangeEvent>

  fun model(modelId: ModelId): PresentationModel
  fun model(modelType: ModelType): Collection<PresentationModel>

  fun registerNamedCommand(actionName: String): Rx.IObservable<ActionEvent>

  /**
   * Batches a series of changes into a single request. This operation has several benefits:
   * If you want to mutate every property of a PM if makes sense that the server is only notified if all changes are applied to the PM (consistent view of the data)
   * Since changes are bundled in a single request, the request overhead can be reduced.
   *
   * This method can be used to build a transaction context.
   */
  fun batch(block: ()->Unit)

}

