package ch.viseon.openOrca.client.impl

import ch.viseon.openOrca.client.ClientOrca
import ch.viseon.openOrca.client.Transmitter
import ch.viseon.openOrca.share.*
import kodando.rxjs.Rx
import kodando.rxjs.filter
import kodando.rxjs.map

class ClientOrcaImpl(val commandListExecutor: CommandListExecutor, val transmitter: Transmitter) : ClientOrca {

  val clientModelStore = DefaultPresentationModelStore()

  private val eventSubject = Rx.Subject<Event>()

  fun executeCommands(commands: Array<CommandData>) {
    val responseCommands = transmitter.sendCommands(commands)
    val responseEvent: Rx.IObservable<Event> = commandListExecutor.execute(
        clientModelStore,
        Rx.Observable.merge(Rx.Observable.from(commands), responseCommands)
    )

    responseEvent.subscribe {
      eventSubject.next(it)
    }
  }

  override fun batch(block: () -> Unit) {
    TODO("not implemented") //To change body of created functions use File | Settings | File Templates.
  }

  override fun observeModelStore(): Rx.IObservable<ModelStoreChangeEvent> {
    return eventSubject
        .filter { it is ModelStoreChangeEvent }
        .map { it as ModelStoreChangeEvent }
  }

  override fun observeModel(modelId: ModelId): Rx.IObservable<PropertyChangeEvent> {
    return eventStreamAsPropertyChangeEvent()
        .filter { it.modelId == modelId }
  }

  override fun observeModel(modelType: ModelType): Rx.IObservable<PropertyChangeEvent> {
    return eventStreamAsPropertyChangeEvent()
        .filter { it.modelType == modelType }
  }

  override fun observeProperty(modelId: ModelId, propertyName: PropertyName): Rx.IObservable<ValueChangeEvent> {
    return eventStreamAsPropertyChangeEvent()
        .filter { it.modelId == modelId }
        .map { it.valueChangeEvent }
  }

  private fun eventStreamAsPropertyChangeEvent(): Rx.IObservable<PropertyChangeEvent> {
    return eventSubject
        .filter { it is PropertyChangeEvent }
        .map { it as PropertyChangeEvent }
  }

  override fun registerNamedCommand(actionName: String): Rx.IObservable<ActionEvent> {
    return eventSubject
        .filter { it is ActionEvent }
        .map { it as ActionEvent }
        .filter { it.actionName == actionName }
  }

  override fun model(modelType: ModelType): Collection<PresentationModel> {
    return clientModelStore[modelType]
  }

  override fun model(modelId: ModelId): PresentationModel {
    return clientModelStore[modelId]
  }
}

